# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.
BEGIN { require 5.006; }
use strict;
use warnings;
use ExtUtils::MakeMaker 6.30;

my %WriteMakefileArgs = (
  'ABSTRACT' => 'Generic interface for GUID/UUID creation',
  'AUTHOR' => 'David Golden <dagolden@cpan.org>',
  'BUILD_REQUIRES' => {
    'Config' => '0',
    'File::Find' => '0',
    'File::Spec' => '0',
    'File::Temp' => '0',
    'Test::More' => '0.92'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::CBuilder' => '0.26',
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'Data-GUID-Any',
  'EXE_FILES' => [],
  'LICENSE' => 'apache',
  'NAME' => 'Data::GUID::Any',
  'PREREQ_PM' => {
    'Exporter' => '0',
    'IPC::Cmd' => '0',
    'strict' => '0',
    'warnings' => '0'
  },
  'VERSION' => '0.003',
  'test' => {
    'TESTS' => 't/*.t'
  }
);
;

$WriteMakefileArgs{PREREQ_PM} ||= {};

eval {
  local @INC = ('lib', @INC);
  require Data::GUID::Any;
  Data::GUID::Any::v1_guid_as_string(); # dies if no provider
  Data::GUID::Any::v4_guid_as_string(); # dies if no provider
  1;
} or do {
  require ExtUtils::CBuilder;
  if ( ExtUtils::CBuilder->new->have_compiler ) {
    $WriteMakefileArgs{PREREQ_PM}{'Data::UUID::MT'} = '0';
  }
  else {
    $WriteMakefileArgs{PREREQ_PM}{'UUID::Tiny'} = '0';
  }
};

# Hey, CPAN Testers, go ahead and test with extra prereqs
# that don't have external library dependencies
if ( $ENV{AUTOMATED_TESTING} ) {
  require ExtUtils::CBuilder;
  $WriteMakefileArgs{BUILD_REQUIRES}{'Data::UUID::MT'} = '0'
    if ExtUtils::CBuilder->new->have_compiler;
  $WriteMakefileArgs{BUILD_REQUIRES}{'UUID::Tiny'} = '0';
}
 


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

