# Generated by default/object.tt
package Paws::SageMaker::ActionSummary;
  use Moose;
  has ActionArn => (is => 'ro', isa => 'Str');
  has ActionName => (is => 'ro', isa => 'Str');
  has ActionType => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has Source => (is => 'ro', isa => 'Paws::SageMaker::ActionSource');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ActionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ActionSummary object:

  $service_obj->Method(Att1 => { ActionArn => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ActionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ActionArn

=head1 DESCRIPTION

Lists the properties of an I<action>. An action represents an action or
activity. Some examples are a workflow step and a model deployment.
Generally, an action involves at least one input artifact or output
artifact.

=head1 ATTRIBUTES


=head2 ActionArn => Str

The Amazon Resource Name (ARN) of the action.


=head2 ActionName => Str

The name of the action.


=head2 ActionType => Str

The type of the action.


=head2 CreationTime => Str

When the action was created.


=head2 LastModifiedTime => Str

When the action was last modified.


=head2 Source => L<Paws::SageMaker::ActionSource>

The source of the action.


=head2 Status => Str

The status of the action.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

