/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.util.Date;
import ucar.ma2.ArrayDouble;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.DateUtil;

public class CEDRICRadarConvention
extends CF1Convention {
    public static boolean isMine(NetcdfFile ncfile) {
        Dimension s = ncfile.findDimension("cedric_general_scaling_factor");
        Variable v = ncfile.findVariable("cedric_run_date");
        return v != null && s != null;
    }

    public CEDRICRadarConvention() {
        this.conventionName = "CEDRICRadar";
    }

    public void augmentDataset(NetcdfDataset ncDataset, CancelTask cancelTask) throws IOException {
        NcMLReader.wrapNcMLresource(ncDataset, "resources/nj22/coords/CEDRICRadar.ncml", cancelTask);
        Variable lat = ncDataset.findVariable("radar_latitude");
        Variable lon = ncDataset.findVariable("radar_longitude");
        float latv = (float)lat.readScalarDouble();
        float lonv = (float)lon.readScalarDouble();
        Variable pv = ncDataset.findVariable("Projection");
        pv.addAttribute(new Attribute("longitude_of_projection_origin", Float.valueOf(lonv)));
        pv.addAttribute(new Attribute("latitude_of_projection_origin", Float.valueOf(latv)));
        Variable sdate = ncDataset.findVariable("start_date");
        Variable stime = ncDataset.findVariable("start_time");
        Variable tvar = ncDataset.findVariable("time");
        String dateStr = sdate.readScalarString();
        String timeStr = stime.readScalarString();
        Date dt = null;
        try {
            dt = DateUtil.parse(dateStr + " " + timeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        int nt = 1;
        ArrayDouble.D1 data = new ArrayDouble.D1(nt);
        data.setDouble(0, (double)(dt.getTime() / 1000L));
        tvar.setCachedData(data, false);
        super.augmentDataset(ncDataset, cancelTask);
    }
}

