/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;

public class JoinParentIndex
implements Join {
    StructureDS parentStructure;
    ArrayStructure parentData;
    String parentIndex;

    public JoinParentIndex(StructureDS parentStructure, String parentIndex) {
        this.parentStructure = parentStructure;
        this.parentIndex = parentIndex;
        try {
            this.parentData = (ArrayStructure)parentStructure.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public StructureData getJoinData(Cursor cursor) {
        StructureData sdata = cursor.tableData[0];
        int index = sdata.getScalarInt(this.parentIndex);
        return this.parentData.getStructureData(index);
    }

    @Override
    public VariableDS findVariable(String axisName) {
        return (VariableDS)this.parentStructure.findVariable(axisName);
    }

    @Override
    public Variable getExtraVariable() {
        return null;
    }

    public String toString() {
        return "JoinParentIndex{parentStructure=" + this.parentStructure + ", parentIndex='" + this.parentIndex + '}';
    }
}

