# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..54\n"; }
END {print "not ok 1\n" unless $loaded;}

use Unix::Syslog qw(:macros :subs);

$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

sub check_defined($$) {
  printf "%-20s", $_[0];
  if (defined eval "$_[0]") {
    print " ok $_[1]\n";
    return 0;
  }
  else {
    print " not ok $_[1]\n";
    return 1;
  }
}

sub check_defined_skip($$) {
  printf "%-20s", $_[0];
  if (defined eval "$_[0]") {
    print " ok $_[1]\n";
    return 0;
  }
  else {
    print " skipped $_[1]\n";
    return 1;
  }
}

my $n = 2;
my $failures = 0;

print "Testing priorities:\n";
$failures += check_defined('LOG_EMERG', $n++);
$failures += check_defined('LOG_EMERG', $n++);
$failures += check_defined('LOG_ALERT', $n++);
$failures += check_defined('LOG_CRIT', $n++);
$failures += check_defined('LOG_ERR', $n++);
$failures += check_defined('LOG_WARNING', $n++);
$failures += check_defined('LOG_NOTICE', $n++);
$failures += check_defined('LOG_INFO', $n++);
$failures += check_defined('LOG_DEBUG', $n++);

$failures += check_defined('LOG_EMERG', $n++);
$failures += check_defined('LOG_ALERT', $n++);
$failures += check_defined('LOG_CRIT', $n++);
$failures += check_defined('LOG_ERR', $n++);
$failures += check_defined('LOG_WARNING', $n++);
$failures += check_defined('LOG_NOTICE', $n++);
$failures += check_defined('LOG_INFO', $n++);
$failures += check_defined('LOG_DEBUG', $n++);

print "\nTesting facilities\n";
$fac = 0;
$failures += check_defined('LOG_KERN', $n++);
$failures += check_defined('LOG_USER', $n++);
$failures += check_defined('LOG_MAIL', $n++);
$failures += check_defined('LOG_DAEMON', $n++);
$failures += check_defined('LOG_AUTH', $n++);
$failures += check_defined('LOG_SYSLOG', $n++);
$failures += check_defined('LOG_LPR', $n++);
$failures += check_defined('LOG_NEWS', $n++);
$failures += check_defined('LOG_UUCP', $n++);
$failures += check_defined('LOG_CRON', $n++);
$failures += check_defined('LOG_LOCAL0', $n++);
$failures += check_defined('LOG_LOCAL1', $n++);
$failures += check_defined('LOG_LOCAL2', $n++);
$failures += check_defined('LOG_LOCAL3', $n++);
$failures += check_defined('LOG_LOCAL4', $n++);
$failures += check_defined('LOG_LOCAL5', $n++);
$failures += check_defined('LOG_LOCAL6', $n++);
$failures += check_defined('LOG_LOCAL7', $n++);

print "\nThese facilities are not defined on all systems:\n";
$failures += check_defined_skip('LOG_AUTHPRIV', $n++);
$failures += check_defined_skip('LOG_FTP', $n++);

print "\nThe number of available facilities is:\n";
$failures += check_defined('LOG_NFACILITIES ', $n++);
$failures += check_defined('LOG_FACMASK', $n++);

print "\nTesting options\n";
$failures += check_defined('LOG_PID', $n++);
$failures += check_defined('LOG_CONS', $n++);
$failures += check_defined('LOG_ODELAY', $n++);
$failures += check_defined('LOG_NDELAY', $n++);
$failures += check_defined('LOG_NOWAIT', $n++);

print "\nThese options are not defined on all systems:\n";
$failures += check_defined_skip('LOG_PERROR', $n++);

print "\nTesting macros for setlogmask()\n";
$failures += check_defined('LOG_MASK(1)', $n++);
$failures += check_defined('LOG_UPTO(1)', $n++);

print "\nThese macros are not defined on all systems:\n";
$failures += check_defined_skip('LOG_PRI(1)', $n++);
$failures += check_defined_skip('LOG_MAKEPRI(1,1)', $n++);
$failures += check_defined_skip('LOG_FAC(1)', $n++);

print "\nOn some systems these functions are undefined and\n",
      "return just empty strings:\n";
$failures += check_defined_skip('priorityname(LOG_EMERG)', $n++);
$failures += check_defined_skip('facilityname(LOG_KERN)', $n++);

print "\nTesting setlogmask:\n";
print "Setting mask to ", LOG_MASK(LOG_INFO), "\n";
$oldmask = setlogmask(LOG_MASK(LOG_INFO));
$newmask = setlogmask($oldmask);
print "New mask is     $newmask  ";
if ($newmask != LOG_MASK(LOG_INFO)) {
  $failures++;
  print "not ";
}
print "ok ", $n++, "\n";

if ($failures == 0) {
  print "\n*** Congratulations! All tests passed.\n\n";
}
else {
  print "\n*** Test results: ", $n-1-$failures, " tests of ", $n-1, " passed!\n\n";
}

print <<EOM;
Testing functions

As the functions `openlog', `closelog' and `syslog' do not return any
value that indicates success or failure, please have a look at the log
file generated by syslogd(8).  The following tests print a message of
the facility `local7' and the priority `info'.

EOM

sub basename {
  my $name = shift;
  $name =~ s@.*/@@;
  return $name;
}

print "Calling closelog() without preceeding openlog()  ";
closelog;
print "ok\n"; # if we got this far, things must have worked right.

print "openlog\n";
openlog(basename($0), LOG_PID, LOG_LOCAL7);

print "syslog\n";

# We need some error message
open(DUMMY, "<foo");

syslog(LOG_INFO, "Unix::Syslog testsuite: The ident string should be \`%s\' (Test %d)", basename($0), $n++);
syslog(LOG_INFO, "Unix::Syslog testsuite: Testing quote character \`%%\' (Test %d)", $n++);
syslog(LOG_INFO, "Unix::Syslog testsuite: This message prints an error message: %m (Test %d)", $n++);
syslog(LOG_INFO, "Unix::Syslog testsuite: This message prints a percent sign followed by the character \`m\': %%m (Test %d)", $n++);
syslog(LOG_INFO, "Unix::Syslog testsuite: This message prints a percent sign followed by an error message: %%%m (Test %d)", $n++);

syslog(LOG_INFO, "Unix::Syslog testsuite: This message prints a percent sign followed by the character \`m\': %s (Test %d)", '%m', $n++);
syslog(LOG_INFO, "Unix::Syslog testsuite: This message prints two percent signs followed by the character \`m\': %s (Test %d)", '%%m', $n++);
syslog(LOG_INFO, "Unix::Syslog testsuite: This message prints three percent signs followed by the character \`m\': %s (Test %d)", '%%%m', $n++);

print "setlogmask\n";
setlogmask(LOG_MASK(LOG_INFO));

print "syslog\n";
syslog(LOG_INFO,  "Unix::Syslog testsuite: (LOG_MASK) This message should be visible (Test %d)\n", $n++);
syslog(LOG_EMERG, "Unix::Syslog testsuite: (LOG_MASK) This message should NOT be visible (Test %d)\n", $n++);

setlogmask(LOG_UPTO(LOG_INFO));
syslog(LOG_INFO,    "Unix::Syslog testsuite: (LOG_UPTO) This message should be visible (Test %d)\n", $n++);
syslog(LOG_EMERG,   "Unix::Syslog testsuite: (LOG_UPTO) This message should be visible (Test %d)\n", $n++);
syslog((LOG_INFO()+1), "Unix::Syslog testsuite: (LOG_UPTO) This message should NOT be visible (Test %d)\n", $n++);

print "closelog\n\n";
closelog;

print "Testing pointer handling in closelog().\n";
print "Calling closelog() a second time.\n";
closelog;
print "This message should not be preceeded by an error message\n";
print "   about dereferenced pointers.\n\n";
