#!/usr/bin/perl

package eBay::API::XML::DataType::ListingDesignerType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingDesignerType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ListingDesignerType

=head1 DESCRIPTION

Contains the IDs for the Listing Designer theme and template (if either are
used) associated with an item, which can optionally be used to enhance the
appearance of the item's description. Cannot be used with Photo Display.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ListingDesignerType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'LayoutID', 'xs:int', '', '', '' ]
	, [ 'OptimalPictureSize', 'xs:boolean', '', '', '' ]
	, [ 'ThemeID', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setLayoutID()

Identifies the Layout template to use when displaying the
item's description. Call GetDescriptionTemplates for valid IDs.
Set to false in GetDescriptionTemplates (or do not specify
LayoutID) to get the standard layout. If a Listing Designer
layout is used (except standard layout), PhotoDisplayType must
be false (or not be specified).
When relisting an item, LayoutID is removed from the listing if you specify
ListingDesignerType without LayoutID. Alternatively, to remove this value
when revising or relisting an item, use DeletedField.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setLayoutID {
  my $self = shift;
  $self->{'LayoutID'} = shift
}

=head2 getLayoutID()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:int'

=cut

sub getLayoutID {
  my $self = shift;
  return $self->{'LayoutID'};
}


=head2 setOptimalPictureSize()

If true, indicates that the item's picture will be enlarged to fit description
of the item.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setOptimalPictureSize {
  my $self = shift;
  $self->{'OptimalPictureSize'} = shift
}

=head2 isOptimalPictureSize()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isOptimalPictureSize {
  my $self = shift;
  return $self->{'OptimalPictureSize'};
}


=head2 setThemeID()

ID for the Listing Designer theme template to use when
displaying the item's description.
When relisting, if you specify ListingDesignerType without
ThemeID, ThemeID is removed from the listing. Alternatively, to remove
this value when revising or relisting an item, use DeletedField.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setThemeID {
  my $self = shift;
  $self->{'ThemeID'} = shift
}

=head2 getThemeID()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:int'

=cut

sub getThemeID {
  my $self = shift;
  return $self->{'ThemeID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
