/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.ConstantPopulation;
import dr.evomodel.bigfasttree.BigFastTreeIntervals;
import dr.evomodel.coalescent.demographicmodel.ConstantPopulationModel;
import dr.evomodel.coalescent.demographicmodel.RescaleAwareDemographic;
import dr.evomodel.tree.TreeModel;

public class CoalescentRescaler {
    private TreeModel tree;
    private ConstantPopulationModel constantPopulationModel;
    private RescaleAwareDemographic rescaleAwareDemographic;
    private BigFastTreeIntervals bigFastTreeIntervals;

    public CoalescentRescaler(TreeModel treeModel, ConstantPopulationModel constantPopulationModel, RescaleAwareDemographic rescaleAwareDemographic) {
        this.tree = treeModel;
        this.constantPopulationModel = constantPopulationModel;
        this.rescaleAwareDemographic = rescaleAwareDemographic;
        this.bigFastTreeIntervals = new BigFastTreeIntervals("constant.population.size.tree", treeModel);
    }

    public TreeModel rescaleTree() {
        double[] dArray = new double[this.bigFastTreeIntervals.getIntervalCount()];
        double[] dArray2 = new double[this.bigFastTreeIntervals.getIntervalCount()];
        for (int i = 0; i < this.bigFastTreeIntervals.getIntervalCount(); ++i) {
            dArray2[i] = this.bigFastTreeIntervals.getInterval(i);
            dArray[i] = dArray2[i] / ((ConstantPopulation)this.constantPopulationModel.getDemographicFunction()).getN0();
        }
        double[] dArray3 = this.rescaleAwareDemographic.rescaleInterval(dArray2, dArray);
        double d = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            int[] nArray = this.bigFastTreeIntervals.getNodeNumbersForInterval(i);
            this.tree.setNodeHeightQuietly(this.tree.getNode(nArray[1]), d += dArray3[i]);
        }
        this.tree.pushTreeChangedEvent();
        return this.tree;
    }
}

