/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.evomodel.treedatalikelihood.preorder.ContinuousExtensionDelegate;
import dr.evomodel.treedatalikelihood.preorder.ModelExtensionProvider;
import dr.inference.model.AbstractModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class ContinuousTraitDataModel
extends AbstractModel
implements ContinuousTraitPartialsProvider,
ModelExtensionProvider {
    private final CompoundParameter parameter;
    private final boolean[] originalMissingIndicators;
    final int numTraits;
    final int dimTrait;
    final PrecisionType precisionType;
    private final boolean[] missingIndicators;
    private boolean useMissingIndices;
    private String tipTraitName = null;
    private static final boolean OLD = false;

    public ContinuousTraitDataModel(String string, CompoundParameter compoundParameter, boolean[] blArray, boolean bl, int n, PrecisionType precisionType) {
        this(string, compoundParameter, blArray, bl, n, compoundParameter.getParameter(0).getDimension() / n, precisionType);
    }

    public ContinuousTraitDataModel(String string, CompoundParameter compoundParameter, boolean[] blArray, boolean bl, int n, int n2, PrecisionType precisionType) {
        super(string);
        this.parameter = compoundParameter;
        this.addVariable(compoundParameter);
        this.originalMissingIndicators = blArray;
        this.useMissingIndices = true;
        this.missingIndicators = bl ? blArray : new boolean[blArray.length];
        this.dimTrait = n;
        this.numTraits = n2;
        this.precisionType = precisionType;
    }

    @Override
    public boolean bufferTips() {
        return true;
    }

    @Override
    public int getTraitCount() {
        return this.numTraits;
    }

    @Override
    public int getTraitDimension() {
        return this.dimTrait;
    }

    @Override
    public String getTipTraitName() {
        return this.tipTraitName;
    }

    @Override
    public void setTipTraitName(String string) {
        this.tipTraitName = string;
    }

    @Override
    public PrecisionType getPrecisionType() {
        return this.precisionType;
    }

    public String getName() {
        return super.getModelName();
    }

    @Override
    public CompoundParameter getParameter() {
        return this.parameter;
    }

    @Override
    public boolean usesMissingIndices() {
        return this.useMissingIndices;
    }

    @Override
    public ContinuousTraitPartialsProvider[] getChildModels() {
        return new ContinuousTraitPartialsProvider[0];
    }

    @Override
    public List<Integer> getMissingIndices() {
        return ContinuousTraitPartialsProvider.indicatorToIndices(this.missingIndicators);
    }

    @Override
    public boolean[] getDataMissingIndicators() {
        return this.missingIndicators;
    }

    List<Integer> getOriginalMissingIndices() {
        return ContinuousTraitPartialsProvider.indicatorToIndices(this.originalMissingIndicators);
    }

    boolean[] getOriginalMissingIndicators() {
        return this.originalMissingIndicators;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.parameter) {
            if (changeType == Variable.ChangeType.VALUE_CHANGED) {
                this.fireModelChanged(this, this.getTaxonIndex(n));
            } else if (changeType == Variable.ChangeType.ALL_VALUES_CHANGED) {
                this.fireModelChanged(this);
            } else {
                throw new RuntimeException("Unhandled parameter change type");
            }
        }
    }

    protected int getTaxonIndex(int n) {
        return n / (this.dimTrait * this.numTraits);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    private double[] getScalarTipPartial(int n) {
        double[] dArray = new double[this.numTraits * (this.dimTrait + 1)];
        Parameter parameter = this.parameter.getParameter(n);
        int n2 = 0;
        for (int i = 0; i < this.numTraits; ++i) {
            boolean bl = false;
            for (int j = 0; j < this.dimTrait; ++j) {
                int n3 = i * this.dimTrait + j;
                int n4 = n3 + this.dimTrait * this.numTraits * n;
                dArray[n2 + j] = parameter.getParameterValue(n3);
                if (this.missingIndicators == null || !this.missingIndicators[n4]) continue;
                bl = true;
            }
            dArray[n2 + this.dimTrait] = bl ? 0.0 : Double.POSITIVE_INFINITY;
            n2 += this.dimTrait + 1;
        }
        return dArray;
    }

    @Override
    public double[] getTipPartial(int n, boolean bl) {
        if (bl) {
            PrecisionType precisionType = PrecisionType.SCALAR;
            int n2 = precisionType.getPartialsDimension(this.dimTrait);
            double d = PrecisionType.getObservedPrecisionValue(false);
            double[] dArray = this.getTipPartial(n, precisionType);
            for (int i = 0; i < this.numTraits; ++i) {
                precisionType.fillPrecisionInPartials(dArray, i * n2, 0, d, this.dimTrait);
            }
            return dArray;
        }
        return this.getTipPartial(n, this.precisionType);
    }

    private double[] getTipPartial(int n, PrecisionType precisionType) {
        int n2 = precisionType.getPartialsDimension(this.dimTrait);
        double[] dArray = new double[this.numTraits * n2];
        Parameter parameter = this.parameter.getParameter(n);
        int n3 = 0;
        for (int i = 0; i < this.numTraits; ++i) {
            int n4 = 0;
            for (int j = 0; j < this.dimTrait; ++j) {
                boolean bl;
                int n5 = i * this.dimTrait + j;
                int n6 = n5 + this.dimTrait * this.numTraits * n;
                dArray[n3 + j] = parameter.getParameterValue(n5);
                boolean bl2 = bl = this.missingIndicators != null && this.missingIndicators[n6];
                if (!bl) {
                    ++n4;
                }
                double d = PrecisionType.getObservedPrecisionValue(bl);
                precisionType.fillPrecisionInPartials(dArray, n3, j, d, this.dimTrait);
            }
            precisionType.fillEffDimInPartials(dArray, n3, n4, this.dimTrait);
            precisionType.fillNoDeterminantInPartials(dArray, n3, this.dimTrait);
            n3 += n2;
        }
        return dArray;
    }

    double[] getTipObservation(int n, PrecisionType precisionType) {
        int n2 = precisionType.getPartialsDimension(this.dimTrait);
        double[] dArray = this.getTipPartial(n, precisionType);
        double[] dArray2 = new double[this.numTraits * this.dimTrait];
        for (int i = 0; i < this.numTraits; ++i) {
            precisionType.copyObservation(dArray, i * n2, dArray2, i * this.dimTrait, this.dimTrait);
        }
        return dArray2;
    }

    @Override
    public ContinuousExtensionDelegate getExtensionDelegate(ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, TreeTrait treeTrait, Tree tree) {
        return new ContinuousExtensionDelegate.NullExtensionDelegate(continuousDataLikelihoodDelegate, this, treeTrait, tree);
    }

    @Override
    public double[] transformTreeTraits(double[] dArray) {
        return (double[])dArray.clone();
    }

    @Override
    public void updateTipDataGradient(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, NodeRef nodeRef, int n, int n2) {
    }

    @Override
    public boolean needToUpdateTipDataGradient(int n, int n2) {
        return false;
    }
}

