/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.alignment.AscertainedSitePatterns;
import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SitePatterns;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.tipstatesmodel.TipStatesModel;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.treelikelihood.AbstractTreeLikelihood;
import dr.oldevomodel.treelikelihood.AminoAcidLikelihoodCore;
import dr.oldevomodel.treelikelihood.GeneralLikelihoodCore;
import dr.oldevomodel.treelikelihood.LikelihoodCore;
import dr.oldevomodel.treelikelihood.NativeAminoAcidLikelihoodCore;
import dr.oldevomodel.treelikelihood.NativeGeneralLikelihoodCore;
import dr.oldevomodel.treelikelihood.NativeNucleotideLikelihoodCore;
import dr.oldevomodel.treelikelihood.NucleotideLikelihoodCore;
import java.util.logging.Logger;

@Deprecated
public class TreeLikelihood
extends AbstractTreeLikelihood {
    private static final boolean DEBUG = false;
    private double[] rootPartials = null;
    protected final FrequencyModel frequencyModel;
    protected final SiteModel siteModel;
    protected final BranchRateModel branchRateModel;
    private final TipStatesModel tipStatesModel;
    private final boolean storePartials;
    protected final boolean integrateAcrossCategories;
    protected int[] siteCategories = null;
    protected double[] patternLogLikelihoods = null;
    protected int categoryCount;
    protected double[] probabilities;
    protected double[] tipPartials;
    protected LikelihoodCore likelihoodCore;

    public TreeLikelihood(PatternList patternList, TreeModel treeModel, SiteModel siteModel, BranchRateModel branchRateModel, TipStatesModel tipStatesModel, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super("treeLikelihood", patternList, treeModel);
        this.storePartials = bl3;
        try {
            int n;
            String string;
            int n2;
            Object object;
            this.siteModel = siteModel;
            this.addModel(siteModel);
            this.frequencyModel = siteModel.getFrequencyModel();
            this.addModel(this.frequencyModel);
            this.tipStatesModel = tipStatesModel;
            this.integrateAcrossCategories = siteModel.integrateAcrossCategories();
            this.categoryCount = siteModel.getCategoryCount();
            Logger logger = Logger.getLogger("dr.evomodel");
            String string2 = "Java general";
            if (this.integrateAcrossCategories) {
                object = patternList.getDataType();
                if (object instanceof Nucleotides) {
                    if (!bl4 && NativeNucleotideLikelihoodCore.isAvailable()) {
                        string2 = "native nucleotide";
                        this.likelihoodCore = new NativeNucleotideLikelihoodCore();
                    } else {
                        string2 = "Java nucleotide";
                        this.likelihoodCore = new NucleotideLikelihoodCore();
                    }
                } else if (object instanceof AminoAcids) {
                    if (!bl4 && NativeAminoAcidLikelihoodCore.isAvailable()) {
                        string2 = "native amino acid";
                        this.likelihoodCore = new NativeAminoAcidLikelihoodCore();
                    } else {
                        string2 = "Java amino acid";
                        this.likelihoodCore = new AminoAcidLikelihoodCore();
                    }
                } else if (object instanceof Codons) {
                    if (!bl4 && NativeGeneralLikelihoodCore.isAvailable()) {
                        string2 = "native general";
                        this.likelihoodCore = new NativeGeneralLikelihoodCore(patternList.getStateCount());
                    } else {
                        string2 = "Java general";
                        this.likelihoodCore = new GeneralLikelihoodCore(patternList.getStateCount());
                    }
                    bl = true;
                } else if (!bl4 && NativeGeneralLikelihoodCore.isAvailable()) {
                    string2 = "native general";
                    this.likelihoodCore = new NativeGeneralLikelihoodCore(patternList.getStateCount());
                } else {
                    string2 = "Java general";
                    this.likelihoodCore = new GeneralLikelihoodCore(patternList.getStateCount());
                }
            } else {
                this.likelihoodCore = new GeneralLikelihoodCore(patternList.getStateCount());
            }
            object = this.getId();
            logger.info("TreeLikelihood(" + (String)(object != null ? object : treeModel.getId()) + ") using " + string2 + " likelihood core");
            logger.info("  " + (bl ? "Using" : "Ignoring") + " ambiguities in tree likelihood.");
            logger.info("  With " + patternList.getPatternCount() + " unique site patterns.");
            if (branchRateModel != null) {
                this.branchRateModel = branchRateModel;
                logger.info("Branch rate model used: " + branchRateModel.getModelName());
            } else {
                this.branchRateModel = new DefaultBranchRateModel();
            }
            this.addModel(this.branchRateModel);
            this.probabilities = new double[this.stateCount * this.stateCount];
            this.likelihoodCore.initialize(this.nodeCount, this.patternCount, this.categoryCount, this.integrateAcrossCategories);
            int n3 = treeModel.getExternalNodeCount();
            int n4 = treeModel.getInternalNodeCount();
            if (tipStatesModel != null) {
                tipStatesModel.setTree(treeModel);
                this.tipPartials = new double[this.patternCount * this.stateCount];
                for (n2 = 0; n2 < n3; ++n2) {
                    string = treeModel.getTaxonId(n2);
                    n = patternList.getTaxonIndex(string);
                    if (n == -1) {
                        throw new TaxonList.MissingTaxonException("Taxon, " + string + ", in tree, " + treeModel.getId() + ", is not found in patternList, " + patternList.getId());
                    }
                    tipStatesModel.setStates(patternList, n, n2, string);
                    this.likelihoodCore.createNodePartials(n2);
                }
                this.addModel(tipStatesModel);
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    string = treeModel.getTaxonId(n2);
                    n = patternList.getTaxonIndex(string);
                    if (n == -1) {
                        if (!bl2) {
                            throw new TaxonList.MissingTaxonException("Taxon, " + string + ", in tree, " + treeModel.getId() + ", is not found in patternList, " + patternList.getId());
                        }
                        if (bl) {
                            this.setMissingPartials(this.likelihoodCore, n2);
                            continue;
                        }
                        this.setMissingStates(this.likelihoodCore, n2);
                        continue;
                    }
                    if (bl) {
                        this.setPartials(this.likelihoodCore, patternList, this.categoryCount, n, n2);
                        continue;
                    }
                    this.setStates(this.likelihoodCore, patternList, n, n2);
                }
            }
            for (n2 = 0; n2 < n4; ++n2) {
                this.likelihoodCore.createNodePartials(n3 + n2);
            }
            if (bl5) {
                this.likelihoodCore.setUseScaling(true);
                logger.info("  Forcing use of partials rescaling.");
            }
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
        this.addStatistic(new SiteLikelihoodsStatistic());
    }

    public final LikelihoodCore getLikelihoodCore() {
        return this.likelihoodCore;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            if (object instanceof TreeChangedEvent) {
                if (((TreeChangedEvent)object).isNodeChanged()) {
                    this.updateNodeAndChildren(((TreeChangedEvent)object).getNode());
                } else if (((TreeChangedEvent)object).isTreeChanged()) {
                    this.updateAllNodes();
                }
            }
        } else if (model == this.branchRateModel) {
            if (n == -1) {
                this.updateAllNodes();
            } else {
                this.updateNode(this.treeModel.getNode(n));
            }
        } else if (model == this.frequencyModel) {
            this.updateAllNodes();
        } else if (model == this.tipStatesModel) {
            if (object instanceof Taxon) {
                for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
                    if (this.treeModel.getNodeTaxon(this.treeModel.getNode(i)) == null || !this.treeModel.getNodeTaxon(this.treeModel.getNode(i)).getId().equalsIgnoreCase(((Taxon)object).getId())) continue;
                    this.updateNode(this.treeModel.getNode(i));
                }
            } else {
                this.updateAllNodes();
            }
        } else if (model instanceof SiteModel) {
            this.updateAllNodes();
        } else {
            throw new RuntimeException("Unknown componentChangedEvent");
        }
        super.handleModelChangedEvent(model, object, n);
    }

    @Override
    protected void storeState() {
        if (this.storePartials) {
            this.likelihoodCore.storeState();
        }
        super.storeState();
    }

    @Override
    protected void restoreState() {
        if (this.storePartials) {
            this.likelihoodCore.restoreState();
        } else {
            this.updateAllNodes();
        }
        super.restoreState();
    }

    @Override
    protected double calculateLogLikelihood() {
        int n;
        int n2;
        if (this.patternLogLikelihoods == null) {
            this.patternLogLikelihoods = new double[this.patternCount];
        }
        if (!this.integrateAcrossCategories) {
            if (this.siteCategories == null) {
                this.siteCategories = new int[this.patternCount];
            }
            for (n2 = 0; n2 < this.patternCount; ++n2) {
                this.siteCategories[n2] = this.siteModel.getCategoryOfSite(n2);
            }
        }
        if (this.tipStatesModel != null) {
            n2 = this.treeModel.getExternalNodeCount();
            for (int i = 0; i < n2; ++i) {
                if (!this.updateNode[i]) continue;
                this.likelihoodCore.setNodePartialsForUpdate(i);
                this.tipStatesModel.getTipPartials(i, this.tipPartials);
                this.likelihoodCore.setCurrentNodePartials(i, this.tipPartials);
            }
        }
        NodeRef nodeRef = this.treeModel.getRoot();
        this.traverse(this.treeModel, nodeRef);
        double d = 0.0;
        double d2 = this.getAscertainmentCorrection(this.patternLogLikelihoods);
        for (n = 0; n < this.patternCount; ++n) {
            d += (this.patternLogLikelihoods[n] - d2) * this.patternWeights[n];
        }
        if (d == Double.NEGATIVE_INFINITY) {
            Logger.getLogger("dr.evomodel").info("TreeLikelihood, " + this.getId() + ", turning on partial likelihood scaling to avoid precision loss");
            this.likelihoodCore.setUseScaling(true);
            this.updateAllNodes();
            this.updateAllPatterns();
            this.traverse(this.treeModel, nodeRef);
            d = 0.0;
            d2 = this.getAscertainmentCorrection(this.patternLogLikelihoods);
            for (n = 0; n < this.patternCount; ++n) {
                d += (this.patternLogLikelihoods[n] - d2) * this.patternWeights[n];
            }
        }
        for (n = 0; n < this.nodeCount; ++n) {
            this.updateNode[n] = false;
        }
        return d;
    }

    public double[] getPatternLogLikelihoods() {
        this.getLogLikelihood();
        double d = this.getAscertainmentCorrection(this.patternLogLikelihoods);
        double[] dArray = new double[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            dArray[i] = this.patternWeights[i] > 0.0 ? (this.patternLogLikelihoods[i] - d) * this.patternWeights[i] : Double.NEGATIVE_INFINITY;
        }
        return dArray;
    }

    protected double getAscertainmentCorrection(double[] dArray) {
        if (this.patternList instanceof AscertainedSitePatterns) {
            return ((AscertainedSitePatterns)this.patternList).getAscertainmentCorrection(dArray);
        }
        return 0.0;
    }

    public void checkScaling() {
    }

    protected boolean traverse(Tree tree, NodeRef nodeRef) {
        int n;
        boolean bl = false;
        int n2 = nodeRef.getNumber();
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nodeRef2 != null && this.updateNode[n2]) {
            double d = this.branchRateModel.getBranchRate(tree, nodeRef);
            double d2 = d * (tree.getNodeHeight(nodeRef2) - tree.getNodeHeight(nodeRef));
            if (d2 < 0.0) {
                throw new RuntimeException("Negative branch length: " + d2);
            }
            this.likelihoodCore.setNodeMatrixForUpdate(n2);
            for (n = 0; n < this.categoryCount; ++n) {
                double d3 = this.siteModel.getRateForCategory(n) * d2;
                this.siteModel.getSubstitutionModel().getTransitionProbabilities(d3, this.probabilities);
                this.likelihoodCore.setNodeMatrix(n2, n, this.probabilities);
            }
            bl = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            boolean bl2 = this.traverse(tree, nodeRef3);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            boolean bl3 = this.traverse(tree, nodeRef4);
            if (bl2 || bl3) {
                n = nodeRef3.getNumber();
                int n3 = nodeRef4.getNumber();
                this.likelihoodCore.setNodePartialsForUpdate(n2);
                if (this.integrateAcrossCategories) {
                    this.likelihoodCore.calculatePartials(n, n3, n2);
                } else {
                    this.likelihoodCore.calculatePartials(n, n3, n2, this.siteCategories);
                }
                ++this.totalOperationCount;
                if (nodeRef2 == null) {
                    double[] dArray = this.frequencyModel.getFrequencies();
                    double[] dArray2 = this.getRootPartials();
                    this.likelihoodCore.calculateLogLikelihoods(dArray2, dArray, this.patternLogLikelihoods);
                }
                bl = true;
            }
        }
        return bl;
    }

    public final double[] getRootPartials() {
        if (this.rootPartials == null) {
            this.rootPartials = new double[this.patternCount * this.stateCount];
        }
        int n = this.treeModel.getRoot().getNumber();
        if (this.integrateAcrossCategories) {
            double[] dArray = this.siteModel.getCategoryProportions();
            this.likelihoodCore.integratePartials(n, dArray, this.rootPartials);
        } else {
            this.likelihoodCore.getPartials(n, this.rootPartials);
        }
        return this.rootPartials;
    }

    public class SiteLikelihoodsStatistic
    extends Statistic.Abstract {
        public SiteLikelihoodsStatistic() {
            super("siteLikelihoods");
        }

        @Override
        public int getDimension() {
            if (TreeLikelihood.this.patternList instanceof SitePatterns) {
                return ((SitePatterns)TreeLikelihood.this.patternList).getSiteCount();
            }
            return TreeLikelihood.this.patternList.getPatternCount();
        }

        @Override
        public String getDimensionName(int n) {
            return TreeLikelihood.this.getTreeModel().getId() + "site-" + n;
        }

        @Override
        public double getStatisticValue(int n) {
            if (TreeLikelihood.this.patternList instanceof SitePatterns) {
                int n2 = ((SitePatterns)TreeLikelihood.this.patternList).getPatternIndex(n);
                if (n2 >= 0) {
                    return TreeLikelihood.this.patternLogLikelihoods[n2] / TreeLikelihood.this.patternWeights[n2];
                }
                return 0.0;
            }
            return TreeLikelihood.this.patternList.getPatternCount();
        }
    }
}

