/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.SitePatterns;
import dr.inferencexml.loggers.LoggerParser;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.PrintWriter;

public class ReportSitePatternMapParser
extends AbstractXMLObjectParser {
    private static final String SITE_PATTERN_MAP = "reportSitePatternMap";
    private static final String FILE_NAME = "fileName";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("fileName", true), new ElementRule(SitePatterns.class)};

    @Override
    public String getParserName() {
        return SITE_PATTERN_MAP;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        PrintWriter printWriter = LoggerParser.getLogFile((XMLObject)xMLObject, (String)this.getParserName());
        SitePatterns sitePatterns = (SitePatterns)xMLObject.getChild(SitePatterns.class);
        int n = sitePatterns.getSiteCount();
        int n2 = sitePatterns.getPatternCount();
        printWriter.println("Site count    = " + n);
        printWriter.println("Pattern count = " + n2);
        printWriter.println("Map (site -> pattern):");
        for (int i = 0; i < n; ++i) {
            int n3 = sitePatterns.getPatternIndex(i);
            printWriter.println(i + 1 + " -> " + (n3 + 1));
        }
        printWriter.close();
        return null;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A weighted list of the unique site patterns (unique columns) in an alignment.";
    }

    @Override
    public Class getReturnType() {
        return Object.class;
    }
}

