/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.distributions.GaussianProcessBasisApproximation;

public class IntegratedSquaredGPApproximation {
    private final double[] coefficients;
    private final double degree;
    private final double boundary;
    private final double mean;
    private final double marginalVariance;
    private final double lengthScale;
    private double integral;
    private double storedIntegral;
    private boolean storedIntegralKnown;

    public IntegratedSquaredGPApproximation(double[] dArray, double d, double d2, double d3, double d4, double d5) {
        this.coefficients = dArray;
        this.boundary = d2;
        this.mean = d3;
        this.marginalVariance = d4;
        this.lengthScale = d5;
        this.degree = d;
    }

    private double getConstantForIntegral(int n) {
        return Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensity(Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)), this.marginalVariance, this.lengthScale, this.degree)) * this.coefficients[n] * Math.sqrt(1.0 / this.boundary);
    }

    private double getConstantForGradient(int n) {
        return Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensity(Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)), this.marginalVariance, this.lengthScale, this.degree)) * Math.sqrt(1.0 / this.boundary);
    }

    public double getIntegral(double d, double d2) {
        double d3 = d2 - d;
        double d4 = this.mean * this.mean * (d2 - d);
        if (d2 > d) {
            int n;
            for (n = 0; n < this.coefficients.length; ++n) {
                d4 += this.getConstantForIntegral(n) * this.getConstantForIntegral(n) * (d3 / 2.0);
                d4 -= 0.25 * this.getConstantForIntegral(n) * this.getConstantForIntegral(n) * (1.0 / Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (Math.sin(2.0 * Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)) * (d2 + this.boundary)) - Math.sin(2.0 * Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)) * (d + this.boundary)));
                d4 -= 2.0 * this.mean * this.getConstantForIntegral(n) * (1.0 / Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (Math.cos(Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)) * (d2 + this.boundary)) - Math.cos(Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)) * (d + this.boundary)));
            }
            for (n = 0; n < this.coefficients.length; ++n) {
                for (int i = n + 1; i < this.coefficients.length; ++i) {
                    double d5 = Math.sin((Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary)) - Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (d2 + this.boundary));
                    double d6 = Math.sin((Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary)) - Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (d + this.boundary));
                    d4 += this.getConstantForIntegral(n) * this.getConstantForIntegral(i) / (Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary)) - Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (d5 - d6);
                    d5 = Math.sin((Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary)) + Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (d2 + this.boundary));
                    d6 = Math.sin((Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary)) + Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (d + this.boundary));
                    d4 += this.getConstantForIntegral(n) * this.getConstantForIntegral(i) / (Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary)) + Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (d6 - d5);
                }
            }
        }
        return d4;
    }

    public double getGradientWrtCoefficient(double d, double d2, int n) {
        double d3 = 0.0;
        d3 += this.getConstantForGradient(n) * this.getConstantForGradient(n) * this.coefficients[n] * (d2 - d - 0.5 * (1.0 / Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (Math.sin(2.0 * Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)) * (d2 + this.boundary)) - Math.sin(2.0 * Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)) * (d + this.boundary))));
        if (d2 > d) {
            for (int i = 0; i < this.coefficients.length; ++i) {
                if (i == n) continue;
                double d4 = Math.sin((Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary)) - Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (d2 + this.boundary));
                double d5 = Math.sin((Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary)) - Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (d + this.boundary));
                d3 += this.getConstantForGradient(i) * this.getConstantForGradient(n) * this.coefficients[i] / (Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary)) - Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary))) * (d4 - d5);
                d4 = Math.sin((Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)) + Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary))) * (d2 + this.boundary));
                d5 = Math.sin((Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)) + Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary))) * (d + this.boundary));
                d3 += this.getConstantForGradient(i) * this.getConstantForGradient(n) * this.coefficients[i] / (Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(n, this.boundary)) + Math.sqrt(GaussianProcessBasisApproximation.getSpectralDensityEigenValue(i, this.boundary))) * (d5 - d4);
            }
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{1.686465, -47.05261, 2.638783, -9.978589, 1.249006, 8.846663, 2.036995, 9.899196, 0.3506009, 3.975602, -1.652094, 2.907649, -7.169512, -1.804519, -4.756368, -28.3502, 23.20718, 28.51416, -5.019321, 4.746734};
        double d = 1.5;
        double d2 = 19.52;
        double d3 = 1.0;
        double d4 = 0.039;
        double d5 = 0.5;
        IntegratedSquaredGPApproximation integratedSquaredGPApproximation = new IntegratedSquaredGPApproximation(dArray, d5, d, d2, d3, d4);
        System.out.println("Integral 1:" + integratedSquaredGPApproximation.getIntegral(-1.0, -0.5));
        System.out.println("Integral 2:" + integratedSquaredGPApproximation.getIntegral(-0.5, 0.0));
        System.out.println("Integral 3:" + integratedSquaredGPApproximation.getIntegral(0.0, 0.5));
        System.out.println("Integral 4:" + integratedSquaredGPApproximation.getIntegral(0.5, 1.0));
    }
}

