/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import no.uib.cipr.matrix.sparse.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompColMatrix
extends AbstractMatrix {
    double[] data;
    int[] columnPointer;
    int[] rowIndex;

    public CompColMatrix(MatrixVectorReader r) throws IOException {
        block13: {
            int i;
            double[] entry;
            int[] column;
            int[] row;
            int numEntries;
            MatrixInfo info;
            block12: {
                int i2;
                super(0, 0);
                info = null;
                info = r.hasInfo() ? r.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = r.readMatrixSize(info);
                this.numRows = size.numRows();
                this.numColumns = size.numColumns();
                numEntries = size.numEntries();
                row = new int[numEntries];
                column = new int[numEntries];
                entry = new double[numEntries];
                r.readCoordinate(row, column, entry);
                r.add(-1, row);
                r.add(-1, column);
                ArrayList cnz = new ArrayList(this.numColumns);
                for (i2 = 0; i2 < this.numColumns; ++i2) {
                    cnz.add(new HashSet());
                }
                for (i2 = 0; i2 < numEntries; ++i2) {
                    ((Set)cnz.get(column[i2])).add(row[i2]);
                }
                if (info.isSymmetric() || info.isSkewSymmetric()) {
                    for (i2 = 0; i2 < numEntries; ++i2) {
                        if (row[i2] == column[i2]) continue;
                        ((Set)cnz.get(row[i2])).add(column[i2]);
                    }
                }
                int[][] nz = new int[this.numColumns][];
                for (i = 0; i < this.numColumns; ++i) {
                    nz[i] = new int[((Set)cnz.get(i)).size()];
                    int j = 0;
                    for (Integer rowind : (Set)cnz.get(i)) {
                        nz[i][j++] = rowind;
                    }
                }
                this.construct(nz);
                for (i = 0; i < size.numEntries(); ++i) {
                    this.set(row[i], column[i], entry[i]);
                }
                if (!info.isSymmetric()) break block12;
                for (i = 0; i < numEntries; ++i) {
                    if (row[i] == column[i]) continue;
                    this.set(column[i], row[i], entry[i]);
                }
                break block13;
            }
            if (!info.isSkewSymmetric()) break block13;
            for (i = 0; i < numEntries; ++i) {
                if (row[i] == column[i]) continue;
                this.set(column[i], row[i], -entry[i]);
            }
        }
    }

    public CompColMatrix(int numRows, int numColumns, int[][] nz) {
        super(numRows, numColumns);
        this.construct(nz);
    }

    private void construct(int[][] nz) {
        int i;
        int nnz = 0;
        for (i = 0; i < nz.length; ++i) {
            nnz += nz[i].length;
        }
        this.columnPointer = new int[this.numColumns + 1];
        this.rowIndex = new int[nnz];
        this.data = new double[nnz];
        if (nz.length != this.numColumns) {
            throw new IllegalArgumentException("nz.length != numColumns");
        }
        for (i = 1; i <= this.numColumns; ++i) {
            this.columnPointer[i] = this.columnPointer[i - 1] + nz[i - 1].length;
            int j = this.columnPointer[i - 1];
            int k = 0;
            while (j < this.columnPointer[i]) {
                this.rowIndex[j] = nz[i - 1][k];
                if (nz[i - 1][k] < 0 || nz[i - 1][k] >= this.numRows) {
                    throw new IllegalArgumentException("nz[" + (i - 1) + "][" + k + "]=" + nz[i - 1][k] + ", which is not a valid row index");
                }
                ++j;
                ++k;
            }
            java.util.Arrays.sort(this.rowIndex, this.columnPointer[i - 1], this.columnPointer[i]);
        }
    }

    private void construct(Matrix A, boolean deep) {
        if (deep) {
            if (A instanceof CompColMatrix) {
                CompColMatrix Ac = (CompColMatrix)A;
                this.data = new double[Ac.data.length];
                this.columnPointer = new int[Ac.columnPointer.length];
                this.rowIndex = new int[Ac.rowIndex.length];
                System.arraycopy(Ac.data, 0, this.data, 0, this.data.length);
                System.arraycopy(Ac.columnPointer, 0, this.columnPointer, 0, this.columnPointer.length);
                System.arraycopy(Ac.rowIndex, 0, this.rowIndex, 0, this.rowIndex.length);
            } else {
                ArrayList cnz = new ArrayList(this.numColumns);
                for (int i = 0; i < this.numColumns; ++i) {
                    cnz.add(new HashSet());
                }
                for (MatrixEntry e : A) {
                    ((Set)cnz.get(e.column())).add(e.row());
                }
                int[][] nz = new int[this.numColumns][];
                for (int i = 0; i < this.numColumns; ++i) {
                    nz[i] = new int[((Set)cnz.get(i)).size()];
                    int j = 0;
                    for (Integer rowind : (Set)cnz.get(i)) {
                        nz[i][j++] = rowind;
                    }
                }
                this.construct(nz);
                this.set(A);
            }
        } else {
            CompColMatrix Ac = (CompColMatrix)A;
            this.columnPointer = Ac.getColumnPointers();
            this.rowIndex = Ac.getRowIndices();
            this.data = Ac.getData();
        }
    }

    public CompColMatrix(Matrix A, boolean deep) {
        super(A);
        this.construct(A, deep);
    }

    public CompColMatrix(Matrix A) {
        this(A, true);
    }

    public int[] getColumnPointers() {
        return this.columnPointer;
    }

    public int[] getRowIndices() {
        return this.rowIndex;
    }

    public double[] getData() {
        return this.data;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        y.scale(1.0 / alpha);
        for (int i = 0; i < this.numColumns; ++i) {
            for (int j = this.columnPointer[i]; j < this.columnPointer[i + 1]; ++j) {
                int n = this.rowIndex[j];
                yd[n] = yd[n] + this.data[j] * xd[i];
            }
        }
        return y.scale(alpha);
    }

    @Override
    public Vector transMult(Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMult(x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        for (int i = 0; i < this.numColumns; ++i) {
            double dot = 0.0;
            for (int j = this.columnPointer[i]; j < this.columnPointer[i + 1]; ++j) {
                dot += this.data[j] * xd[this.rowIndex[j]];
            }
            yd[i] = dot;
        }
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        int i = 0;
        while (i < this.numColumns) {
            double dot = 0.0;
            for (int j = this.columnPointer[i]; j < this.columnPointer[i + 1]; ++j) {
                dot += this.data[j] * xd[this.rowIndex[j]];
            }
            int n = i++;
            yd[n] = yd[n] + alpha * dot;
        }
        return y;
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        int index = this.getIndex(row, column);
        this.data[index] = value;
    }

    @Override
    public void add(int row, int column, double value) {
        int index;
        this.check(row, column);
        int n = index = this.getIndex(row, column);
        this.data[n] = this.data[n] + value;
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        int index = Arrays.binarySearch(this.rowIndex, row, this.columnPointer[column], this.columnPointer[column + 1]);
        if (index >= 0) {
            return this.data[index];
        }
        return 0.0;
    }

    private int getIndex(int row, int column) {
        int i = Arrays.binarySearch(this.rowIndex, row, this.columnPointer[column], this.columnPointer[column + 1]);
        if (i != -1 && this.rowIndex[i] == row) {
            return i;
        }
        throw new IndexOutOfBoundsException("Entry (" + (row + 1) + ", " + (column + 1) + ") is not in the matrix structure");
    }

    @Override
    public CompColMatrix copy() {
        return new CompColMatrix(this);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new CompColMatrixIterator();
    }

    @Override
    public CompColMatrix zero() {
        java.util.Arrays.fill(this.data, 0.0);
        return this;
    }

    private class CompColMatrixEntry
    implements MatrixEntry {
        private int column;
        private int cursor;

        private CompColMatrixEntry() {
        }

        public void update(int column, int cursor) {
            this.column = column;
            this.cursor = cursor;
        }

        public int row() {
            return CompColMatrix.this.rowIndex[this.cursor];
        }

        public int column() {
            return this.column;
        }

        public double get() {
            return CompColMatrix.this.data[this.cursor];
        }

        public void set(double value) {
            CompColMatrix.this.data[this.cursor] = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompColMatrixIterator
    implements Iterator<MatrixEntry> {
        private int column;
        private int cursor;
        private CompColMatrixEntry entry;

        public CompColMatrixIterator() {
            this.entry = new CompColMatrixEntry();
            this.nextNonEmptyColumn();
        }

        private void nextNonEmptyColumn() {
            while (this.column < CompColMatrix.this.numColumns() && CompColMatrix.this.columnPointer[this.column] == CompColMatrix.this.columnPointer[this.column + 1]) {
                ++this.column;
            }
            this.cursor = CompColMatrix.this.columnPointer[this.column];
        }

        @Override
        public boolean hasNext() {
            return this.cursor < CompColMatrix.this.data.length;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.column, this.cursor);
            if (this.cursor < CompColMatrix.this.columnPointer[this.column + 1] - 1) {
                ++this.cursor;
            } else {
                ++this.column;
                this.nextNonEmptyColumn();
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

