/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.AbstractOutlierVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class LevelShift
extends AbstractOutlierVariable {
    public static final String CODE = "LS";
    boolean zeroEnded = true;

    public LevelShift(Day p) {
        super(p);
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        int n = data.getLength();
        double Zero = this.zeroEnded ? -1.0 : 0.0;
        double One = this.zeroEnded ? 0.0 : 1.0;
        TsPeriod pstart = new TsPeriod(start.getFrequency(), this.position);
        int xpos = pstart.minus(start);
        if (xpos <= 0) {
            data.set(One);
        } else if (xpos >= n) {
            data.set(Zero);
        } else {
            data.range(0, xpos).set(Zero);
            data.range(xpos, n).set(One);
        }
    }

    @Override
    public OutlierType getOutlierType() {
        return OutlierType.LS;
    }

    @Override
    public String getCode() {
        return CODE;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return domain.search(this.position) > 0;
    }

    public boolean isZeroEnded() {
        return this.zeroEnded;
    }

    public void setZeroEnded(boolean value) {
        this.zeroEnded = value;
    }

    @Override
    public IOutlierVariable.FilterRepresentation getFilterRepresentation(int freq) {
        return new IOutlierVariable.FilterRepresentation(new RationalBackFilter(BackFilter.ONE, BackFilter.D1), this.zeroEnded ? -1.0 : 0.0);
    }
}

