/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evomodel.substmodel.GlmSubstitutionModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.AbstractGlmSubstitutionModelGradient;
import dr.evomodel.treedatalikelihood.discrete.AbstractLogAdditiveSubstitutionModelGradient;
import dr.inference.distribution.GeneralizedLinearModel;
import dr.inference.model.Parameter;
import dr.util.Transform;

public class RandomEffectsSubstitutionModelGradient
extends AbstractGlmSubstitutionModelGradient {
    private final int[][] mapEffectToIndices;

    public RandomEffectsSubstitutionModelGradient(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, GlmSubstitutionModel glmSubstitutionModel, AbstractLogAdditiveSubstitutionModelGradient.ApproximationMode approximationMode) {
        super(string, treeDataLikelihood, beagleDataLikelihoodDelegate, glmSubstitutionModel, approximationMode);
        int n = this.stateCount * (this.stateCount - 1);
        if (this.getDimension() != n) {
            if (this.getDimension() == n / 2) {
                throw new RuntimeException("Not yet implemented");
            }
            throw new IllegalArgumentException("Unable to determine random effects count");
        }
        this.mapEffectToIndices = this.makeAsymmetricMap();
    }

    @Override
    AbstractGlmSubstitutionModelGradient.ParameterMap makeParameterMap(final GeneralizedLinearModel generalizedLinearModel) {
        return new AbstractGlmSubstitutionModelGradient.ParameterMap(){

            @Override
            public double[] getCovariateColumn(int n) {
                return null;
            }

            @Override
            public Parameter getParameter() {
                return generalizedLinearModel.getRandomEffect(0);
            }
        };
    }

    @Override
    protected double preProcessNormalization(double[] dArray, double[] dArray2, boolean bl) {
        double d = 0.0;
        if (bl) {
            for (int i = 0; i < this.stateCount; ++i) {
                for (int j = 0; j < this.stateCount; ++j) {
                    d += dArray[this.index(i, j)] * dArray2[this.index(i, j)];
                }
            }
        }
        return d;
    }

    @Override
    double processSingleGradientDimension(int n, double[] dArray, double[] dArray2, double[] dArray3, boolean bl, double d, double d2, Transform transform, boolean bl2) {
        double d3 = dArray2[this.indexIJ(n)];
        double d4 = (dArray[this.indexIJ(n)] - dArray[this.indexII(n)]) * d3;
        if (bl) {
            d4 -= d3 * dArray3[this.indexI(n)] * d;
        }
        return d4;
    }

    private int[][] makeAsymmetricMap() {
        int n;
        int n2;
        int[][] nArrayArray = new int[this.stateCount * (this.stateCount - 1)][];
        int n3 = 0;
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            n = n2 + 1;
            while (n < this.stateCount) {
                nArrayArray[n3++] = new int[]{n2, n++};
            }
        }
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            n = n2 + 1;
            while (n < this.stateCount) {
                nArrayArray[n3++] = new int[]{n++, n2};
            }
        }
        return nArrayArray;
    }

    private int indexIJ(int n) {
        int[] nArray = this.mapEffectToIndices[n];
        return nArray[0] * this.stateCount + nArray[1];
    }

    private int indexII(int n) {
        int[] nArray = this.mapEffectToIndices[n];
        return nArray[0] * this.stateCount + nArray[0];
    }

    private int indexI(int n) {
        int[] nArray = this.mapEffectToIndices[n];
        return nArray[0];
    }
}

