/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.distribution.LinearRegression;
import dr.inference.distribution.MultivariateDistributionLikelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.RegressionGibbsEffectOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class RegressionMetropolizedIndicatorOperator
extends SimpleMCMCOperator {
    public static final String MH_OPERATOR = "regressionMetropolizedIndicatorOperator";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(Parameter.class), new ElementRule(MultivariateDistributionLikelihood.class), new ElementRule(LinearRegression.class), new ElementRule("indicator", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("mask", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true)};

        @Override
        public String getParserName() {
            return RegressionMetropolizedIndicatorOperator.MH_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            LinearRegression linearRegression = (LinearRegression)xMLObject.getChild(LinearRegression.class);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            MultivariateDistributionLikelihood multivariateDistributionLikelihood = (MultivariateDistributionLikelihood)xMLObject.getChild(MultivariateDistributionLikelihood.class);
            if (multivariateDistributionLikelihood.getDistribution().getType().compareTo("MultivariateNormal") != 0) {
                throw new XMLParseException("Only a multivariate normal prior is conjugate");
            }
            XMLObject xMLObject2 = xMLObject.getChild("indicator");
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild("mask");
            Parameter parameter3 = null;
            if (xMLObject2 != null && (parameter3 = (Parameter)xMLObject2.getChild(Parameter.class)).getDimension() != parameter2.getDimension()) {
                throw new XMLParseException("Indicator and mask parameter must have the same dimension");
            }
            RegressionMetropolizedIndicatorOperator regressionMetropolizedIndicatorOperator = new RegressionMetropolizedIndicatorOperator(linearRegression, parameter, parameter2, multivariateDistributionLikelihood, parameter3);
            regressionMetropolizedIndicatorOperator.setWeight(d);
            return regressionMetropolizedIndicatorOperator;
        }

        @Override
        public String getParserDescription() {
            return "This element returns a multivariate Gibbs operator on an internal node trait.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Parameter mask;
    private Parameter indicators;
    private Parameter effect;
    private RegressionGibbsEffectOperator effectOperator;
    private double[] mean = null;
    private double[][] variance = null;
    private double[][] precision = null;

    public RegressionMetropolizedIndicatorOperator(LinearRegression linearRegression, Parameter parameter, Parameter parameter2, MultivariateDistributionLikelihood multivariateDistributionLikelihood, Parameter parameter3) {
        this.effectOperator = new RegressionGibbsEffectOperator(linearRegression, parameter, parameter2, multivariateDistributionLikelihood);
        this.effect = parameter;
        this.indicators = parameter2;
        this.mask = parameter3;
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public String getOperatorName() {
        return MH_OPERATOR;
    }

    @Override
    public double doOperation() {
        int n;
        double d = 0.0;
        if (this.mask != null) {
            n = 0;
            for (int i = 0; i < this.mask.getDimension(); ++i) {
                n = (int)((double)n + this.mask.getParameterValue(i));
            }
            if (n == 0) {
                throw new RuntimeException("Mask parameter has all zeros");
            }
        }
        if (this.mean == null) {
            n = this.effect.getDimension();
            this.mean = new double[n];
            this.variance = new double[n][n];
            this.precision = new double[n][n];
        }
        this.effectOperator.computeForwardDensity(this.mean, this.variance, this.precision);
        d += MultivariateNormalDistribution.logPdf(this.effect.getParameterValues(), this.mean, this.precision, MultivariateNormalDistribution.calculatePrecisionMatrixLogDeterminate(this.precision), 1.0);
        do {
            n = MathUtils.nextInt(this.indicators.getDimension());
        } while (this.mask != null && this.mask.getParameterValue(n) == 0.0);
        this.indicators.setParameterValue(n, 1.0 - this.indicators.getParameterValue(n));
        this.effectOperator.doOperation();
        this.mean = this.effectOperator.getLastMean();
        this.variance = this.effectOperator.getLastVariance();
        this.precision = this.effectOperator.getLastPrecision();
        return d -= MultivariateNormalDistribution.logPdf(this.effect.getParameterValues(), this.mean, this.precision, MultivariateNormalDistribution.calculatePrecisionMatrixLogDeterminate(this.precision), 1.0);
    }
}

