/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ConditionalTraitSimulationHelper;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.IntegratedFactorAnalysisLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.LatentFactorModel;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import dr.xml.Reportable;
import java.util.ArrayList;

public interface FactorAnalysisOperatorAdaptor
extends Reportable {
    public int getNumberOfTaxa();

    public int getNumberOfTraits();

    public int getNumberOfFactors();

    public double getFactorValue(int var1, int var2);

    public double getDataValue(int var1, int var2);

    public double getLoadingsValue(int var1);

    public double getColumnPrecision(int var1);

    public void setLoadingsForTraitQuietly(int var1, double[] var2);

    public void reflectLoadingsForFactor(int var1);

    public void fireLoadingsChanged();

    public void drawFactors();

    public boolean isNotMissing(int var1, int var2);

    public Parameter[] getFactorDependentParameters();

    public Parameter[] getLoadingsDependentParameter();

    public MatrixParameterInterface getLoadings();

    public ArrayList<Likelihood> getLikelihoods();

    public static class IntegratedFactors
    extends Abstract {
        private final IntegratedFactorAnalysisLikelihood factorLikelihood;
        private final TreeDataLikelihood treeLikelihood;
        private final ConditionalTraitSimulationHelper factorSimulationHelper;
        private final Parameter precision;
        private final CompoundParameter data;
        private double[] factors;
        private static final boolean DEBUG = false;

        public IntegratedFactors(IntegratedFactorAnalysisLikelihood integratedFactorAnalysisLikelihood, TreeDataLikelihood treeDataLikelihood) {
            super(integratedFactorAnalysisLikelihood.getLoadings());
            this.factorLikelihood = integratedFactorAnalysisLikelihood;
            this.treeLikelihood = treeDataLikelihood;
            this.precision = integratedFactorAnalysisLikelihood.getPrecision();
            this.data = integratedFactorAnalysisLikelihood.getParameter();
            this.factorSimulationHelper = ((ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate()).getExtensionHelper();
        }

        @Override
        public int getNumberOfTaxa() {
            return this.factorLikelihood.getNumberOfTaxa();
        }

        @Override
        public int getNumberOfTraits() {
            return this.factorLikelihood.getNumberOfTraits();
        }

        @Override
        public int getNumberOfFactors() {
            return this.factorLikelihood.getNumberOfFactors();
        }

        @Override
        public double getFactorValue(int n, int n2) {
            return this.factors[n2 * this.getNumberOfFactors() + n];
        }

        @Override
        public double getDataValue(int n, int n2) {
            return this.data.getParameterValue(n, n2);
        }

        @Override
        public double getColumnPrecision(int n) {
            return this.precision.getParameterValue(n);
        }

        @Override
        public void drawFactors() {
            this.factors = this.factorSimulationHelper.drawTraitsAbove(this.factorLikelihood);
        }

        @Override
        public boolean isNotMissing(int n, int n2) {
            int n3 = n2 * this.getNumberOfTraits() + n;
            return !this.factorLikelihood.getDataMissingIndicators()[n3];
        }

        @Override
        public Parameter[] getFactorDependentParameters() {
            return new Parameter[]{this.factorLikelihood.getLoadings(), this.factorLikelihood.getParameter(), this.factorLikelihood.getPrecision()};
        }

        @Override
        public Parameter[] getLoadingsDependentParameter() {
            return this.getFactorDependentParameters();
        }

        @Override
        public ArrayList<Likelihood> getLikelihoods() {
            ArrayList<Likelihood> arrayList = new ArrayList<Likelihood>();
            arrayList.add(this.factorLikelihood);
            arrayList.add(this.treeLikelihood);
            return arrayList;
        }

        @Override
        public String getReport() {
            StringBuilder stringBuilder = new StringBuilder(this.factorSimulationHelper.getReport());
            stringBuilder.append("\n\n");
            stringBuilder.append(super.getReport());
            stringBuilder.append("Taxon order:");
            for (int i = 0; i < this.getNumberOfTaxa(); ++i) {
                stringBuilder.append(" " + this.treeLikelihood.getTree().getTaxonId(i));
            }
            return stringBuilder.toString();
        }
    }

    public static class SampledFactors
    extends Abstract {
        private final LatentFactorModel LFM;

        public SampledFactors(LatentFactorModel latentFactorModel) {
            super(latentFactorModel.getLoadings());
            this.LFM = latentFactorModel;
        }

        @Override
        public int getNumberOfTaxa() {
            return this.LFM.getFactors().getColumnDimension();
        }

        @Override
        public int getNumberOfTraits() {
            return this.LFM.getLoadings().getRowDimension();
        }

        @Override
        public int getNumberOfFactors() {
            assert (this.LFM.getFactors().getRowDimension() == this.LFM.getLoadings().getColumnDimension());
            return this.LFM.getFactors().getRowDimension();
        }

        @Override
        public double getFactorValue(int n, int n2) {
            return this.LFM.getFactors().getParameterValue(n, n2);
        }

        @Override
        public double getDataValue(int n, int n2) {
            assert (n2 < this.getNumberOfTaxa());
            assert (n < this.getNumberOfTraits());
            assert (this.LFM.getScaledData().getRowDimension() == this.getNumberOfTraits());
            assert (this.LFM.getScaledData().getColumnDimension() == this.getNumberOfTaxa());
            return this.LFM.getScaledData().getParameterValue(n, n2);
        }

        @Override
        public double getColumnPrecision(int n) {
            return this.LFM.getColumnPrecision().getParameterValue(n, n);
        }

        @Override
        public void drawFactors() {
        }

        @Override
        public boolean isNotMissing(int n, int n2) {
            Parameter parameter = this.LFM.getMissingIndicator();
            int n3 = n2 * this.getNumberOfTraits() + n;
            return parameter == null || parameter.getParameterValue(n3) != 1.0;
        }

        @Override
        public Parameter[] getFactorDependentParameters() {
            return new Parameter[]{this.LFM.getFactors()};
        }

        @Override
        public Parameter[] getLoadingsDependentParameter() {
            return new Parameter[]{this.LFM.getFactors(), this.LFM.getColumnPrecision(), this.LFM.getData()};
        }

        @Override
        public ArrayList<Likelihood> getLikelihoods() {
            ArrayList<Likelihood> arrayList = new ArrayList<Likelihood>();
            arrayList.add(this.LFM);
            return arrayList;
        }
    }

    public static abstract class Abstract
    implements FactorAnalysisOperatorAdaptor,
    Reportable {
        private final MatrixParameterInterface loadings;

        Abstract(MatrixParameterInterface matrixParameterInterface) {
            this.loadings = matrixParameterInterface;
        }

        @Override
        public MatrixParameterInterface getLoadings() {
            return this.loadings;
        }

        @Override
        public void setLoadingsForTraitQuietly(int n, double[] dArray) {
            for (int i = 0; i < dArray.length; ++i) {
                this.loadings.setParameterValueQuietly(n, i, dArray[i]);
            }
        }

        @Override
        public void reflectLoadingsForFactor(int n) {
            double d = this.loadings.getParameterValue(n, n);
            if (d < 0.0) {
                for (int i = n; i < this.loadings.getRowDimension(); ++i) {
                    this.loadings.setParameterValueQuietly(i, n, -1.0 * this.loadings.getParameterValue(i, n));
                }
            }
        }

        @Override
        public void fireLoadingsChanged() {
            this.loadings.fireParameterChangedEvent();
        }

        @Override
        public double getLoadingsValue(int n) {
            return this.loadings.getParameterValue(n);
        }

        @Override
        public String getReport() {
            int n;
            int n2 = 20000;
            int n3 = this.getNumberOfFactors();
            int n4 = this.getNumberOfTaxa();
            int n5 = n3 * n4;
            double[] dArray = new double[n5];
            double[][] dArray2 = new double[n5][n5];
            for (int i = 0; i < n2; ++i) {
                this.fireLoadingsChanged();
                this.drawFactors();
                for (int j = 0; j < n4; ++j) {
                    for (n = 0; n < n3; ++n) {
                        double d = this.getFactorValue(n, j);
                        int n6 = n + j * n3;
                        dArray[n6] = dArray[n6] + d;
                        for (int k = 0; k < n4; ++k) {
                            for (int i2 = 0; i2 < n3; ++i2) {
                                double d2 = this.getFactorValue(i2, k);
                                double[] dArray3 = dArray2[n + j * n3];
                                int n7 = i2 + k * n3;
                                dArray3[n7] = dArray3[n7] + d * d2;
                            }
                        }
                    }
                }
            }
            double[] dArray4 = new double[n5];
            double[][] dArray5 = new double[n5][n5];
            for (n = 0; n < n5; ++n) {
                dArray4[n] = dArray[n] / (double)n2;
                int n8 = 0;
                while (n8 < n5) {
                    double[] dArray6 = dArray2[n];
                    int n9 = n8++;
                    dArray6[n9] = dArray6[n9] / (double)n2;
                }
            }
            for (n = 0; n < n5; ++n) {
                for (int i = 0; i < n5; ++i) {
                    dArray5[n][i] = dArray2[n][i] - dArray4[n] * dArray4[i];
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass() + "Report:\n");
            stringBuilder.append("Factor mean:\n");
            stringBuilder.append(new Vector(dArray4));
            stringBuilder.append("\n\n");
            stringBuilder.append("Factor covariance:\n");
            stringBuilder.append(new Matrix(dArray5));
            stringBuilder.append("\n\n");
            return stringBuilder.toString();
        }
    }
}

