/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.analysis;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.timeseries.analysis.DiagnosticInfo;
import ec.tstoolkit.timeseries.analysis.DiagnosticTarget;
import ec.tstoolkit.timeseries.analysis.DiagnosticTsFunction;
import ec.tstoolkit.timeseries.analysis.ITsProcessing;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataFunction;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class RevisionHistory<T extends IProcResults> {
    private final ITsProcessing<T> m_processing;
    private final HashMap<TsDomain, T> m_cache = new HashMap();
    private final TsDomain m_domainT;

    public RevisionHistory(ITsProcessing<T> processing, TsDomain domain) {
        this.m_processing = processing;
        this.m_domainT = domain;
        this.m_cache.put(this.m_domainT, processing.process(this.m_domainT));
    }

    public ITsProcessing<T> getProcessing() {
        return this.m_processing;
    }

    public TsDomain getReferenceDomain() {
        return this.m_domainT;
    }

    public T getReferenceInfo() {
        return this.tsInfo(this.m_domainT);
    }

    public double[] laggedSeriesRevision(String series, TsPeriod period, int lag, int count, DiagnosticInfo mode, DiagnosticTarget target) {
        TsPeriod start = this.m_domainT.getStart();
        TsDomain domain = new TsDomain(start, period.minus(start) + 1);
        IProcResults[] ilag = new IProcResults[count];
        TsDomain ldomain = domain;
        for (int i = 0; i < count; ++i) {
            ldomain = ldomain.extend(0, lag);
            ilag[i] = this.tsInfo(ldomain);
        }
        double[] rslt = new double[count];
        if (target == DiagnosticTarget.Final) {
            TsData Tdata;
            TsData iT = this.tsInfo(this.m_domainT);
            TsData tsData = Tdata = iT != null ? iT.getData(series, TsData.class) : null;
            if (Tdata == null) {
                return null;
            }
            for (int i = 0; i < count; ++i) {
                TsData tdata;
                rslt[i] = Double.NaN;
                if (ilag[i] == null || (tdata = ilag[i].getData(series, TsData.class)) == null) continue;
                int idx = tdata.getLength() - 1;
                rslt[i] = mode.asFunction().apply(Tdata, tdata, idx);
            }
        } else {
            TsData cdata;
            TsData it = this.tsInfo(domain);
            TsData tsData = cdata = it != null ? it.getData(series, TsData.class) : null;
            if (cdata == null) {
                return null;
            }
            for (int i = 0; i < count; ++i) {
                TsData tdata;
                rslt[i] = Double.NaN;
                if (ilag[i] == null || (tdata = ilag[i].getData(series, TsData.class)) == null) continue;
                int idx = tdata.getLength() - 1;
                rslt[i] = mode.asFunction().apply(cdata, tdata, idx);
            }
        }
        return rslt;
    }

    public TsData referenceSeries(String series) {
        TsData it = this.tsInfo(this.m_domainT);
        return it == null ? null : it.getData(series, TsData.class);
    }

    public TsData revision(String item, TsPeriod start) {
        TsPeriod p0 = this.m_domainT.getStart();
        TsData rslt = new TsData(start, this.m_domainT.getEnd().minus(start));
        int len = start.minus(p0) + 1;
        int i = 0;
        while (i < rslt.getLength()) {
            TsDomain rdom = new TsDomain(p0, len);
            Double output = this.tsInfo(rdom);
            if (output != null) {
                Double d = output.getData(item, Double.TYPE);
                if (d != null) {
                    rslt.set(i, (double)d);
                } else {
                    rslt.set(i, Double.NaN);
                }
            }
            ++i;
            ++len;
        }
        return rslt;
    }

    @Deprecated
    public List<TsData> Select(String item, Date beg, Date end) {
        return this.select(item, beg, end);
    }

    public List<TsData> select(String item, Date beg, Date end) {
        int n;
        ArrayList<TsData> s = new ArrayList<TsData>();
        TsPeriod start = this.m_domainT.getStart();
        TsPeriod pbeg = new TsPeriod(start.getFrequency(), beg);
        TsPeriod pend = new TsPeriod(start.getFrequency(), end);
        if (pend.isAfter(this.m_domainT.getLast())) {
            pend = this.m_domainT.getLast();
        }
        if ((n = pend.minus(pbeg)) >= 0) {
            int len = pbeg.minus(start) + 1;
            for (int i = 0; i <= n; ++i) {
                try {
                    TsData q;
                    TsDomain dom = new TsDomain(start, len++);
                    TsData output = this.tsInfo(dom);
                    if (output == null || (q = output.getData(item, TsData.class)) == null) continue;
                    s.add(q);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return s;
    }

    public TsData series(String series, TsPeriod period) {
        TsPeriod start = this.m_domainT.getStart();
        TsDomain domain = new TsDomain(start, period.minus(start) + 1);
        TsData it = this.tsInfo(domain);
        if (it == null) {
            return null;
        }
        return it.getData(series, TsData.class);
    }

    public double seriesRevision(String series, TsPeriod period, DiagnosticInfo mode) {
        return this.seriesRevision(series, period, mode.asFunction());
    }

    public double seriesRevision(String series, TsPeriod period, DiagnosticTsFunction fn) {
        TsPeriod start = this.m_domainT.getStart();
        TsDomain domain = new TsDomain(start, period.minus(start) + 1);
        TsData it = this.tsInfo(domain);
        if (it == null) {
            return Double.NaN;
        }
        TsData iT = this.tsInfo(this.m_domainT);
        TsData tdata = it.getData(series, TsData.class);
        TsData Tdata = iT.getData(series, TsData.class);
        if (tdata == null || Tdata == null) {
            return Double.NaN;
        }
        int idx = domain.getLength() - 1;
        return fn.apply(Tdata, tdata, idx);
    }

    public T tsInfo(TsDomain domain) {
        IProcResults info = (IProcResults)this.m_cache.get(domain);
        if (info == null) {
            info = this.m_processing.process(domain);
            this.m_cache.put(domain, info);
        }
        return (T)info;
    }

    public TsData tsRevision(String item, TsPeriod period, TsPeriod start) {
        TsPeriod p0 = this.m_domainT.getStart();
        int pos = period.minus(p0);
        TsData rslt = new TsData(start, this.m_domainT.getEnd().minus(start));
        int len = start.minus(p0) + 1;
        int i = 0;
        while (i < rslt.getLength()) {
            TsDomain rdom = new TsDomain(p0, len);
            TsData output = this.tsInfo(rdom);
            if (output != null) {
                TsData t = output.getData(item, TsData.class);
                if (t != null) {
                    rslt.set(i, t.get(pos));
                } else {
                    rslt.set(i, Double.NaN);
                }
            }
            ++i;
            ++len;
        }
        return rslt;
    }

    public TsData tsRevision(String item, TsPeriod period, TsPeriod start, TsDataFunction fn) {
        TsPeriod p0 = this.m_domainT.getStart();
        int pos = period.minus(p0);
        TsData rslt = new TsData(start, this.m_domainT.getEnd().minus(start));
        int len = start.minus(p0) + 1;
        int i = 0;
        while (i < rslt.getLength()) {
            TsDomain rdom = new TsDomain(p0, len);
            TsData output = this.tsInfo(rdom);
            if (output != null) {
                TsData t = output.getData(item, TsData.class);
                if (t != null) {
                    rslt.set(i, fn.apply(t, pos));
                } else {
                    rslt.set(i, Double.NaN);
                }
            }
            ++i;
            ++len;
        }
        return rslt;
    }
}

