/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import java.text.Normalizer;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringIterator
implements Iterator<Character> {
    public static final char CR = '\n';
    public static final char LF = '\r';
    public static final char SPACE = ' ';
    private String text_ = null;
    private int position_ = 0;

    public StringIterator(String text) {
        this.reset(text);
    }

    public static String normalize(String text) {
        StringBuilder builder = new StringBuilder(text.length());
        StringIterator iterator = new StringIterator(text);
        while (iterator.hasNext()) {
            char c = iterator.next().charValue();
            if (StringIterator.isApostrophe(c)) {
                builder.append('\'');
                continue;
            }
            if (StringIterator.isSingleQuotationMark(c)) {
                builder.append('\'');
                continue;
            }
            if (StringIterator.isDoubleQuotationMark(c)) {
                builder.append('\"');
                continue;
            }
            if (c == '\u00a0') {
                builder.append(' ');
                continue;
            }
            if (c == '\r' && iterator.peek() == '\n') continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String trimLeft(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int c = s.codePointAt(i);
            if (StringIterator.isWhitespace(c)) continue;
            return i == 0 ? s : s.substring(i);
        }
        return "";
    }

    public static String trimRight(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            int c = s.codePointAt(i);
            if (StringIterator.isWhitespace(c)) continue;
            return i == s.length() - 1 ? s : s.substring(0, i + 1);
        }
        return "";
    }

    public static boolean isBlank(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int c = s.codePointAt(i);
            if (StringIterator.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCapitalized(String s) {
        boolean isFirst = true;
        for (int i = 0; i < s.length(); ++i) {
            int c = s.codePointAt(i);
            if (isFirst) {
                if (c != Character.toUpperCase(c)) {
                    return false;
                }
                isFirst = StringIterator.isWhitespace(c);
                continue;
            }
            if (c == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int c = s.codePointAt(i);
            if (c == Character.toUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int c = s.codePointAt(i);
            if (c == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static String removeDiacriticalMarks(String s) {
        String decomposed = Normalizer.normalize(s, Normalizer.Form.NFD);
        Pattern diacriticals = Pattern.compile("\\p{InCombiningDiacriticalMarks}");
        Matcher matcher = diacriticals.matcher(decomposed);
        String noDiacriticals = matcher.replaceAll("");
        return Normalizer.normalize(noDiacriticals, Normalizer.Form.NFC);
    }

    public static boolean isWhitespace(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    public static boolean isPunctuation(char c) {
        return StringIterator.isInRange(c, 33, 47) || StringIterator.isInRange(c, 58, 64) || StringIterator.isInRange(c, 91, 96) || StringIterator.isInRange(c, 123, 126);
    }

    public static boolean isGeneralPunctuation(char c) {
        return StringIterator.isInRange(c, 8192, 8303);
    }

    public static boolean isCjkSymbol(char c) {
        return StringIterator.isInRange(c, 12289, 12291) || StringIterator.isInRange(c, 12296, 12319);
    }

    public static boolean isCurrency(char c) {
        return c == '$' || StringIterator.isInRange(c, 162, 165) || StringIterator.isInRange(c, 8352, 8399);
    }

    public static boolean isArrow(char c) {
        return StringIterator.isInRange(c, 8592, 8703) || StringIterator.isInRange(c, 10224, 10239) || StringIterator.isInRange(c, 10496, 10623);
    }

    public static boolean isHyphen(char c) {
        return c == '-' || StringIterator.isInRange(c, 8208, 8212);
    }

    public static boolean isApostrophe(char c) {
        return c == '\'' || c == '\u2019';
    }

    public static boolean isListMark(char c) {
        return c == '-' || c == '\uf0f0' || c == '\u2022' || c == '\u2023' || c == '\u203b' || c == '\u2043';
    }

    public static boolean isTerminalMark(char c) {
        return c == '.' || c == '?' || c == '!' || c == '\u203c' || StringIterator.isInRange(c, 8263, 8265);
    }

    public static boolean isSeparatorMark(char c) {
        return c == ',' || c == ';' || c == ':' || c == '|' || c == '/' || c == '\\';
    }

    public static boolean isQuotationMark(char c) {
        return StringIterator.isSingleQuotationMark(c) || StringIterator.isDoubleQuotationMark(c);
    }

    public static boolean isSingleQuotationMark(char c) {
        return c == '\'' || c == '`' || StringIterator.isInRange(c, 8216, 8219);
    }

    public static boolean isDoubleQuotationMark(char c) {
        return c == '\"' || c == '\u00ab' || c == '\u00bb' || StringIterator.isInRange(c, 8220, 8223);
    }

    public static boolean isBracket(char c) {
        return StringIterator.isLeftBracket(c) || StringIterator.isRightBracket(c);
    }

    public static boolean isLeftBracket(char c) {
        return c == '(' || c == '{' || c == '[' || c == '<';
    }

    public static boolean isRightBracket(char c) {
        return c == ')' || c == '}' || c == ']' || c == '>';
    }

    private static boolean isInRange(char c, int start, int end) {
        return start <= c && c <= end;
    }

    public static String join(List<String> strings, char separator) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.size(); ++i) {
            if (i > 0) {
                builder.append(separator);
            }
            builder.append(strings.get(i));
        }
        return builder.toString();
    }

    public void reset(String text) {
        if (text == null) {
            throw new NullPointerException("\"text\" should not be null");
        }
        this.text_ = text;
        this.position_ = 0;
    }

    @Override
    public boolean hasNext() {
        return !this.isEndOfText();
    }

    @Override
    public Character next() {
        char c = this.peek();
        this.moveAhead();
        return Character.valueOf(c);
    }

    public boolean isEndOfText() {
        return this.position_ >= this.text_.length();
    }

    public char peek(int ahead) {
        int pos = this.position_ + ahead;
        if (pos < this.text_.length()) {
            return this.text_.charAt(pos);
        }
        return '\u0000';
    }

    public char peek() {
        return this.peek(0);
    }

    public void moveAhead() {
        this.moveAhead(1);
    }

    public void moveAhead(int ahead) {
        this.position_ = Math.min(this.position_ + ahead, this.text_.length());
    }

    public String string() {
        return this.text_;
    }

    public int position() {
        return this.position_;
    }

    public int remaining() {
        return this.text_.length() - this.position_;
    }

    public String extract(int start) {
        return this.extract(start, this.text_.length());
    }

    public String extract(int start, int end) {
        return this.text_.substring(start, end);
    }

    public void moveTo(String s) {
        this.position_ = this.text_.indexOf(s, this.position_);
        if (this.position_ < 0) {
            this.position_ = this.text_.length();
        }
    }

    public void moveTo(char c) {
        this.position_ = this.text_.indexOf(c, this.position_);
        if (this.position_ < 0) {
            this.position_ = this.text_.length();
        }
    }

    public void moveTo(char[] chars) {
        while (!this.isInArray(this.peek(), chars) && !this.isEndOfText()) {
            this.moveAhead();
        }
    }

    public void movePast(char[] chars) {
        while (this.isInArray(this.peek(), chars) && !this.isEndOfText()) {
            this.moveAhead();
        }
    }

    public void moveToEndOfLine() {
        char c = this.peek();
        while (c != '\r' && c != '\n' && !this.isEndOfText()) {
            this.moveAhead();
            c = this.peek();
        }
    }

    public void moveToWhitespace() {
        while (!StringIterator.isWhitespace(this.peek()) && !this.isEndOfText()) {
            this.moveAhead();
        }
    }

    public void movePastWhitespace() {
        while (StringIterator.isWhitespace(this.peek()) && !this.isEndOfText()) {
            this.moveAhead();
        }
    }

    private boolean isInArray(char c, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            return true;
        }
        return false;
    }
}

