## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.width = "500px", fig.align = "center", dpi = 300
)
library(dplyr)
library(ggplot2)
theme_set(theme_bw())
library(rticulate)

## ----load-data----------------------------------------------------------------
library(rticulate)
data(tongue)
tongue

## -----------------------------------------------------------------------------
polar <- tongue %>%
    filter(speaker == "it01", X < 40) %>%
    transform_coord()

## -----------------------------------------------------------------------------
polar %>%
    ggplot(aes(angle, radius, colour = c2_place)) +
    geom_point() +
    scale_colour_discrete(name = "Place of C2") +
    theme(legend.position = "top")

## -----------------------------------------------------------------------------
polar %>%
    ggplot(aes(angle, radius, colour = c2_place, group = rec_date)) +
    geom_path() +
    scale_colour_discrete(name = "Place of C2") +
    coord_radial(theta = "x",
             start = -0.5 * pi, end = 0.5 * pi, 
             direction = -1, expand = FALSE) +
    scale_x_continuous(breaks = pi/4 * (0:4),
                     labels = expression(0, pi/4, pi/2, 3/4*pi, pi),
                     limits = c(0, pi)) +
    ylim(0, 100) +
    theme(legend.position = "top", axis.title = element_blank(),
        panel.border = element_blank())

