% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios.r
\name{scenarios}
\alias{scenarios}
\title{scenarios function (fully optimized with Rcpp)
This function computes the mean and covariances to draw from the conditional forecast
The actual draw is done in the simscen function}
\usage{
scenarios(
  h = 3,
  path = NULL,
  obs = NULL,
  free_shocks = NULL,
  n_sample = NULL,
  data_ = NULL,
  g = NULL,
  Sigma_g = NULL,
  posterior = NULL,
  matrices = NULL
)
}
\arguments{
\item{h}{forecast horizon}

\item{path}{conditional path of observables}

\item{obs}{position of observable(s)}

\item{free_shocks}{position of non-driving shocks (NA if all driving)}

\item{n_sample}{Number of draws to sample (<= n_draws)}

\item{data_}{Optional matrix of data (default taken from matrices$Z)}

\item{g}{Optional matrix of non-driving shocks}

\item{Sigma_g}{Optional covariance matrix of non-driving shocks}

\item{posterior}{Optional posterior object (default taken from calling environment)}

\item{matrices}{Optional matrices object from gen_mats() (default taken from calling environment)}
}
\value{
list of mu_eps, Sigma_eps, mu_y, Sigma_y, big_b, big_M, draws_used
}
\description{
scenarios function (fully optimized with Rcpp)
This function computes the mean and covariances to draw from the conditional forecast
The actual draw is done in the simscen function
}
\examples{
\donttest{
library(APRScenario)
data(NKdata)

# Minimal example with a toy specification
spec <- bsvarSIGNs::specify_bsvarSIGN$new(as.matrix(NKdata[,2:4]), p = 1)
posterior <- bsvars::estimate(spec, S = 10)  # Use small S for fast test
matrices<-gen_mats(posterior = posterior, specification = spec)
# and having posterior object
 scenario_result <- scenarios(h = 2, 
                              path = c(1.0, 1.1), 
                              obs = 1, 
                              free_shocks = NA, 
                              posterior = posterior, 
                              matrices = matrices)
}
}
