% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_conditional_forecasts.r
\name{simulate_conditional_forecasts}
\alias{simulate_conditional_forecasts}
\title{Simulate paths from conditional forecast distributions}
\usage{
simulate_conditional_forecasts(mu_y, Sigma_y, varnames, n_sim = 1000)
}
\arguments{
\item{mu_y}{Array (n_state × 1 × n_draws): conditional forecast mean}

\item{Sigma_y}{Array (n_state × n_state × n_draws): conditional forecast variance}

\item{varnames}{Character vector of variable names (length = number of variables)}

\item{n_sim}{Number of simulations per draw}
}
\value{
Array of dimensions (n_state x n_sim x n_draws) of simulated draws with named rows
}
\description{
Simulate paths from conditional forecast distributions
}
\note{
Users should set their own seed before calling this function if reproducible results are desired.
}
\examples{
# Example with simulated data
# Create example data dimensions
n_var <- 3
h <- 2
n_draws <- 5
n_state <- n_var * h

# Simulate conditional forecast means and covariances
set.seed(123)
mu_y <- array(rnorm(n_state * 1 * n_draws), dim = c(n_state, 1, n_draws))
Sigma_y <- array(0, dim = c(n_state, n_state, n_draws))
for (d in 1:n_draws) {
  temp_cov <- matrix(rnorm(n_state^2), n_state, n_state)
  Sigma_y[,,d] <- temp_cov \%*\% t(temp_cov) + diag(n_state) * 0.1
}

# Variable names
varnames <- c("GDP", "CPI", "FFR")

# Simulate conditional forecasts
sims <- simulate_conditional_forecasts(mu_y, Sigma_y, varnames, n_sim = 50)
print(dim(sims))
print(rownames(sims)[1:6])
}
