% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE.ERROR.XY.R
\name{ATE.ERROR.XY}
\alias{ATE.ERROR.XY}
\title{ATE.ERROR.XY Function for Estimating Average Treatment Effect (ATE) with Measurement Error in X and Misclassification in Y}
\usage{
ATE.ERROR.XY(
  Y_star,
  A,
  Z,
  X_star,
  p11,
  p10,
  sigma_epsilon,
  B = 100,
  Lambda = seq(0, 2, by = 0.5),
  extrapolation = "linear",
  bootstrap_number = 250
)
}
\arguments{
\item{Y_star}{Numeric vector. The observed binary outcome variable, possibly misclassified.}

\item{A}{Numeric vector. The treatment indicator (1 if treated, 0 if control).}

\item{Z}{Numeric vector. A precisely measured covariate vector.}

\item{X_star}{Numeric vector. A covariate vector subject to measurement error.}

\item{p11}{Numeric. The probability of correctly classified Y given Y = 1.}

\item{p10}{Numeric. The probability of misclassified Y given Y = 0.}

\item{sigma_epsilon}{Numeric. The covariance matrix Sigma_epsilon for the measurement error model.}

\item{B}{Integer. The number of simulated datasets.}

\item{Lambda}{Numeric vector. A sequence of lambda values for simulated datasets.}

\item{extrapolation}{Character. A regression model used for extrapolation ("linear", "quadratic", "nonlinear").}

\item{bootstrap_number}{Numeric. The number of bootstrap samples (default is 250).}
}
\value{
A list containing:
\describe{
\item{summary}{A data frame with the following columns:
\itemize{
\item \code{Naive_ATE}: Naive estimate of the ATE.
\item \code{Sigma_epsilon}: The covariance matrix Sigma_epsilon for the measurement error model.
\item \code{p10}: The probability of misclassified Y given Y = 0.
\item \code{p11}: The probability of correctly classified Y given Y = 1.
\item \code{Extrapolation}:  A regression model used for extrapolation ("linear", "quadratic", "nonlinear").
\item \code{ATE}: Mean ATE estimate from the bootstrap samples.
\item \code{SE}: Standard error of the ATE estimate.
\item \code{CI}: 95\% confidence interval for the ATE estimate.
}
}
\item{boxplot}{A ggplot object representing the boxplot of the ATE estimates.}
}
}
\description{
The \code{ATE.ERROR.XY} function implements a method for estimating the Average Treatment Effect (ATE) that accounts for both measurement error in covariates and misclassification in the binary outcome variable Y.
}
\details{
The \code{ATE.ERROR.XY} function is designed to handle measurement error in covariates and misclassification in outcomes by using the augmented simulation-extrapolation approach.
}
\examples{
\donttest{
library(ATE.ERROR)
data(Simulated_data)
Y_star <- Simulated_data$Y_star
A <- Simulated_data$T
Z <- Simulated_data$Z
X_star <- Simulated_data$X_star
p11 <- 0.8
p10 <- 0.2
sigma_epsilon <- 0.1
B <- 100
Lambda <- seq(0, 2, by = 0.5)
bootstrap_number <- 10
result <- ATE.ERROR.XY(Y_star, A, Z, X_star, p11, p10, sigma_epsilon, B, Lambda, 
                       "linear", bootstrap_number)
print(result$summary)
print(result$boxplot)
}

}
