% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_results.r
\name{merge_results}
\alias{merge_results}
\title{Merge results from multiple ActivePathways analyses}
\usage{
merge_results(
  enriched_pathways,
  enriched_pathways_directional,
  gmt_file,
  output_prefix = "Aggregated",
  col_colors = NULL,
  tests = c(gsub("^Genes_", "", grep("^Genes_", colnames(enriched_pathways), value =
    TRUE)), "combined")
)
}
\arguments{
\item{enriched_pathways}{A data.table returned by ActivePathways}

\item{enriched_pathways_directional}{A data.table returned by ActivePathways}

\item{gmt_file}{Path to GMT file}

\item{output_prefix}{A string prefix for output files}

\item{col_colors}{A character vector of colors for each test (must match length of tests)}

\item{tests}{A character vector of names for the data sources (e.g., c('rna', 'protein', 'combined')) or NULL}
}
\value{
A list containing the merged results
}
\description{
This function combines results from multiple ActivePathways analyses into a single set of files
for visualization in Cytoscape. This is particularly useful for comparing results with and without
directional penalties.
}
\examples{
\dontrun{
# Run two different ActivePathways analyses
enriched_pathways <- ActivePathways(
  pval_matrix, gmt = fname_GMT2, cytoscape_file_tag = "original_")

enriched_pathways_directional <- ActivePathways(
  pval_matrix, gmt = fname_GMT2, cytoscape_file_tag = "directional_",
  merge_method = "DPM", scores_direction = dir_matrix, 
  constraints_vector = constraints_vector)

# Merge the results
merge_results(
  enriched_pathways, enriched_pathways_directional,
  gmt_file = fname_GMT2,
  output_prefix = "Aggregated",
  col_colors = c("#FF0000", "#00FF00", "#FFFFF0"),
  tests = c('rna', 'protein', 'combined')
)
}
}
