% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporal_overlap.R
\name{temporal_overlap}
\alias{temporal_overlap}
\title{Temporal Overlap}
\usage{
temporal_overlap(sequences_long)
}
\arguments{
\item{sequences_long}{A data frame containing sequences with columns: sequence_nr, element, start_time, and end_time.}
}
\value{
A data frame summarizing the mean overlap elements and mean overlap proportion for each element.
}
\description{
This function calculates the temporal overlap of elements in sequences.
It determines how much each element overlaps with other elements in the same sequence.
}
\examples{
sequences_long <- data.frame(
  sequence_nr = c(1, 1, 1, 2, 2),
  element = c("A", "B", "C", "A", "B"),
  start_time = c(0, 5, 10, 0, 5),
  end_time = c(5, 10, 15, 5, 10)
)
result <- temporal_overlap(sequences_long)
print(result)

}
