% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeFeldRegion.R
\name{computeFeldRegion}
\alias{computeFeldRegion}
\title{Retrieving Feldpausch regions}
\usage{
computeFeldRegion(coord, level = c("region"))
}
\arguments{
\item{coord}{Coordinates of the site(s), a matrix/dataframe with two columns (e.g. cbind(longitude, latitude)) (see examples).}

\item{level}{a string or a vector of string, the length must match the number of rows of the parameter coord.
This parameter gives the scale at which Feldpausch regions should be assigned. There are tree levels:
\itemize{
\item \code{region}: Models assign at sub-continent levels, value by default
\item \code{continent}: Models assign at the Africa, South America, Asia and Australia levels
\item \code{world}: Pantropical model
}}
}
\value{
The function returns a vector with the Feldpausch et al. (2012)'s regions that can be
incorporated in the \code{retrieveH} function.
}
\description{
Extract the Feldpausch et al. (2012)'s regions using local coordinates.
}
\examples{
#' # One study site
lat <- 4.08
long <- -52.68
coord <- cbind(long, lat)
\donttest{
FeldRegion <- computeFeldRegion(coord)
}

# Several study sites (here three sites)
long <- c(-52.68, -51.12, -53.11)
lat <- c(4.08, 3.98, 4.12)
coord <- cbind(long, lat)
\donttest{
FeldRegion <- computeFeldRegion(coord)
}

}
\references{
Feldpausch, T.R., et al. (2012). \emph{Tree height integrated into pantropical forest biomass estimates.}
Biogeosciences, 9, 3381–3403.
}
\author{
Arthur PERE
}
