% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIS.R
\name{read_bis}
\alias{read_bis}
\title{Read a BIS data set from a local file}
\usage{
read_bis(file_path)
}
\arguments{
\item{file_path}{Character. Path to the CSV file to be read (usually obtained
via manual download from the BIS homepage).}
}
\value{
A tibble data frame.
}
\description{
Read a BIS data set from a local file
}
\examples{
\dontrun{
# Example 1: Read a locally stored CSV
df <- read_bis("WS_CBPOL_csv_flat.csv")

# Example 2: Read a locally stored ZIP
df <- read_bis(.unzip_file("WS_CBPOL_csv_flat.zip"))
}

}
