% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brazil_vehicle_brands.R
\name{get_brazil_vehicle_brands}
\alias{get_brazil_vehicle_brands}
\title{Get Vehicle Brands from BrasilAPI (FIPE Data)}
\usage{
get_brazil_vehicle_brands(tipo_veiculo)
}
\arguments{
\item{tipo_veiculo}{A string indicating the type of vehicle. Must be one of `"carros"`, `"motos"`, or `"caminhoes"`.}
}
\value{
A tibble (data frame) with the following columns:
\itemize{
  \item \code{nome}: Brand name.
  \item \code{valor}: FIPE code of the brand.
}
}
\description{
This function retrieves a list of vehicle brands in Brazil using the BrasilAPI
endpoint, which provides data sourced from FIPE (Fundação Instituto de Pesquisas Econômicas).
The user must specify the type of vehicle: `"carros"`, `"motos"`, or `"caminhoes"`.
}
\details{
This function sends a GET request to the BrasilAPI endpoint and parses the list of vehicle brands.
If the API returns an error (e.g., invalid vehicle type), the function will return \code{NULL}.
}
\note{
Requires internet connection. Only supports Brazilian vehicle types defined by BrasilAPI.
}
\examples{
\dontrun{
# Retrieve list of car brands
cars <- get_brazil_vehicle_brands("carros")
head(cars)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
