% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ITCdat}
\alias{ITCdat}
\title{Sample participant data from a binary intertemporal choice task (aka delay discounting task)}
\format{
A data frame with 120 rows and 3 variables:
\describe{
  \item{Amt1}{Delayed reward amount, in dollars}
  \item{Delay1}{Delay until the receipt of \code{Amt1}, in days}
  \item{Choice}{Choice between binary options. \code{Choice==1} means participnat chose the delayed option (i.e., \code{Amt1} in \code{Delay1} days). \code{Choice==0} means participnat chose the immediate option (i.e., $20 now)}
}
}
\source{
Kable, J. W., Caulfield, M. K., Falcone, M., McConnell, M., Bernardo, L., Parthasarathi, T., ... & Diefenbach, P. (2017). No effect of commercial cognitive training on brain activity, choice behavior, or cognitive performance. Journal of Neuroscience, 37(31), 7390-7402.
}
\usage{
ITCdat
}
\description{
A dataset containing one sample participant's 120 binary choices between a delayed monetary option (\code{Amt1} in \code{Delay1}) and a immediate monetary option ($20 now).
The immediate monetary option was always '$20 now' across all trials
}
\keyword{datasets}
