% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Legend.R
\name{add_Legend}
\alias{add_Legend}
\title{Add Legend}
\usage{
add_Legend(bb, LegOpt, Items)
}
\arguments{
\item{bb}{bounding box of your plot area. for example, 
\code{bb=st_bbox(SmallBathy())} or \code{bb=st_bbox(MyPolys)}.}

\item{LegOpt}{list of general legend options. for example:

\code{LegOpt=list(Title="Speed",Subtitle="(km/h)")}.}

\item{Items}{list, or list of lists containing options for each item to be displayed in the legend. for example:

\code{item1=list(Text="one",Shape="rectangle")}

\code{item2=list(Text="two",Shape="circle")}

\code{Items=list(item1,item2)}}
}
\value{
Legend added to current plot.
}
\description{
Add a legend to you map. Give the bounding box of your plot and lists of parameters as inputs.
}
\section{LegOpt options}{


\itemize{
  \item Title: character, title of the legend, set to NULL for no title.
  \item Subtitle: character, subtitle of the legend, set to NULL for no subtitle.
  \item Pos: character, general position of the legend. One of "bottomright" (default),
   "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" or "center".
  \item BoxW: numeric, legend box width (see figure below).
  \item BoxH: numeric, legend box height (see figure below).
  \item PosX: numeric, horizontal adjustment of legend (see figure below).
  \item PosY: numeric, vertical adjustment of legend (see figure below). 
  \item Boxexp: numeric, vector of length 4 controlling the expansion of the legend box, 
   given as c(xmin,xmax,ymin,ymax), see figure below.
  \item Boxbd: character, color of the background of the legend box. set to NA for no background.
  \item Boxcol: character, color of the border of the legend box. Set to NA for no box.
  \item Boxlwd: numeric, line thickness of the legend box. Set Boxcol to NA for no box.
  \item Titlefontsize: numeric, size of the legend title.
  \item Subtitlefontsize: numeric, size of the legend subtitle.
  \item TitleAdj: numeric vector of length 2, as c(x,y) to adjust title location (see figure below).
  \item SubtitleAdj: numeric vector of length 2, as c(x,y) to adjust subtitle location.
}
}

\section{Items options that are common to all items}{


\itemize{
  \item Text: character, text of the item.
  \item Shape: character, shape description, one of "rectangle", "circle", "ellipse", "line", 
  "arrow" or "none". Using "none" will leave a blank space that can be filled by a user-defined shape.
  \item ShpFill: character, fill color of shape, set to NA for no fill.
  \item ShpBord: character, border color of shape, set to NA for no border.
  \item ShpHash: logical (TRUE/FALSE) to add hashed lines to the shape (see \link{create_Hashes}).
  \item Shplwd: numeric, line thickness of the shape's border, set ShpBord to NA for no border.
  \item fontsize: numeric, size of the text.
  \item STSpace: numeric, space between the Shape and its Text (see figure below).
  \item ShiftX: numeric, shift Shape and Text left or right (see figure below).
  \item ShiftY: numeric, shift Shape and Text up or down (see figure below).
  \item Hashcol: character, color of hashes (if ShpHash is TRUE), see \link{create_Hashes} for details.
  \item Hashangle: numeric, angle of hashes (if ShpHash is TRUE), see \link{create_Hashes} for details.
  \item Hashspacing: numeric, spacing between hashes (if ShpHash is TRUE), see \link{create_Hashes} for details.
  \item Hashwidth: numeric, width of hashes (if ShpHash is TRUE), see see \link{create_Hashes} for details.
}
}

\section{Items options that are specific to the item's Shape}{


\itemize{
  \item RectW: numeric, width of rectangle shape.
  \item RectH: numeric, height of rectangle shape.
  \item CircD: numeric, diameter of circle shape.
  \item EllW: numeric, width of ellipse shape.
  \item EllH: numeric, height of ellipse shape.
  \item EllA: numeric, angle of ellipse shape.
  \item LineTyp: numeric, type of line shape (0=blank, 1=solid, 2=dashed, 3=dotted, 4=dotdash, 5=longdash, 6=twodash).
  \item LineL: numeric, length of the line shape.
  \item ArrL: numeric, length of the arrow shape.
  \item ArrPwidth: numeric, width of arrow's path. see \link{create_Arrow} for details.
  \item ArrHlength: numeric, length of arrow's head. see \link{create_Arrow} for details.
  \item ArrHwidth: numeric, width of arrow's head. see \link{create_Arrow} for details.
  \item Arrdlength: numeric, length of dashes for dashed arrows. see \link{create_Arrow} for details.
  \item Arrtype: character, arrow type either "normal" or "dashed". see \link{create_Arrow} for details. 
  \item Arrcol: character, color of the arrow. see \link{create_Arrow} for details.
  \item Arrtrans: numeric, transparency of the arrow. see \link{create_Arrow} for details.
}


The figure below shows some of the options used to customize the legend box and its items. 
Blue arrows represent location options and black arrows represent sizing options:

\if{html}{\figure{Addlegenddetails.png}{options: width=800}}
\if{latex}{\figure{Addlegenddetails.pdf}{options: width=6in}}
}

\examples{

# For more examples, see:
# https://github.com/ccamlr/CCAMLRGIS#53-adding-legends

# Set general options:

LegOpt=list( 
Title= "Title",
Subtitle="(Subtitle)",
Pos = "bottomright",
BoxW= 80,
BoxH= 170,
Boxexp = c(5,-2,-4,-4),
Titlefontsize = 2
)


#Create separate items, each with their own options:


Rectangle1=list(
  Text="Rectangle 1", 
  Shape="rectangle",
  ShpFill="cyan",
  ShpBord="blue",
  Shplwd=2,
  fontsize=1.2,
  STSpace=3,
  RectW=10,
  RectH=7
)

Rectangle2=list(
  Text="Rectangle 2", 
  Shape="rectangle",
  ShpFill="red",
  ShpBord="orange",
  ShpHash=TRUE,
  Shplwd=2,
  fontsize=1.2,
  STSpace=3,
  RectW=10,
  RectH=7,
  Hashcol="white",
  Hashangle=45,
  Hashspacing=1,
  Hashwidth=1
)

Circle1=list(
  Text="Circle 1", 
  Shape="circle",
  ShpFill="grey",
  ShpBord="yellow",
  Shplwd=2,
  fontsize=1.2,
  STSpace=3,
  CircD=10
)

Circle2=list(
  Text="Circle 2", 
  Shape="circle",
  ShpFill="white",
  ShpBord="red",
  ShpHash=TRUE,
  Shplwd=2,
  fontsize=1.2,
  STSpace=3,
  CircD=10,
  Hashcol="black",
  Hashangle=0,
  Hashspacing=2,
  Hashwidth=2
)

Ellipse1=list(
  Text="Ellipse 1", 
  Shape="ellipse",
  ShpFill="white",
  ShpBord="darkblue",
  Shplwd=2,
  fontsize=1.2,
  STSpace=3,
  EllW=10,
  EllH=6,
  EllA=35
)

Ellipse2=list(
  Text="Ellipse 2", 
  Shape="ellipse",
  ShpFill="red",
  ShpBord="green",
  ShpHash=TRUE,
  Shplwd=2,
  fontsize=1.2,
  STSpace=3,
  EllW=10,
  EllH=7,
  EllA=0,
  Hashcol="black",
  Hashangle=-45,
  Hashspacing=1.5,
  Hashwidth=1.5
)

Line1=list(
  Text="Line 1", 
  Shape="line",
  ShpFill="black",
  Shplwd=5,
  fontsize=1.2,
  STSpace=3,
  LineL=10
)

Line2=list(
  Text="Line 2", 
  Shape="line",
  Shplwd=5,
  ShpFill="green",
  Shplwd=5,
  fontsize=1.2,
  STSpace=3,
  LineTyp=6, 
  LineL=10
)

Arrow1=list(
  Text="Arrow 1", 
  Shape="arrow",
  ShpBord="green",
  Shplwd=1,
  ArrL=10,
  ArrPwidth=5,
  ArrHlength=15, 
  ArrHwidth=10, 
  Arrcol="orange",
  fontsize=1.2,
  STSpace=3
)

Arrow2=list(
  Text="Arrow 2", 
  Shape="arrow",
  ShpBord=NA,
  ArrL=10,
  ArrPwidth=5,
  ArrHlength=15, 
  ArrHwidth=10, 
  Arrdlength=0, 
  Arrtype="dashed",
  Arrcol=c("red","green","blue"),
  fontsize=1.2,
  STSpace=3
)

Arrow3=list(
  Text="Arrow 3", 
  Shape="arrow",
  ShpBord=NA,
  ArrL=10,
  ArrPwidth=5,
  ArrHlength=15, 
  ArrHwidth=10, 
  Arrdlength=5, 
  Arrtype="dashed",
  Arrcol="darkgreen",
  fontsize=1.2,
  STSpace=3
)

Arrow4=list(
  Text="Arrow 4", 
  Shape="arrow",
  ShpBord="black",
  Shplwd=0.1,
  ArrL=10,
  ArrPwidth=5,
  ArrHlength=15, 
  ArrHwidth=10, 
  Arrcol="pink",
  ShpHash=TRUE,
  Hashcol="blue",
  Hashangle=-45,
  Hashspacing=1,
  Hashwidth=1,
  fontsize=1.2,
  STSpace=3
)

None=list(
  Text="None", 
  Shape="none",
  fontsize=1.2,
  STSpace=3,
  ShiftX=10
)


#Combine all items into a single list:

Items=list(Rectangle1,Rectangle2,Circle1,Circle2,
Ellipse1,Ellipse2,Line1,Line2,Arrow1,Arrow2,Arrow3,Arrow4,None)

#manually build a bounding box (same as st_bbox(load_ASDs())):

bb=st_bbox(c(xmin=-3348556,xmax=4815055,ymax=4371127,ymin=-3329339),
           crs = st_crs(6932))
bx=st_as_sfc(bb) #Convert to polygon to plot it

#Plot and add legend

plot(bx,col="grey")
add_Legend(bb,LegOpt,Items)

}
\seealso{
\code{\link{create_Hashes}}, \code{\link{create_Arrow}}, \code{\link{create_Ellipse}},
\code{\link{add_labels}}, \code{\link{add_Cscale}}, \code{\link{add_PieLegend}}.
}
