% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{get_eff_weights}
\alias{get_eff_weights}
\title{Get effective weights}
\usage{
get_eff_weights(coin, out2 = "df")
}
\arguments{
\item{coin}{A coin class object}

\item{out2}{Either \code{"coin"} or \code{"df"}}
}
\value{
Either an iMeta data frame with effective weights as an added column, or an updated coin with effective
weights added to \code{.$Meta$Ind}.
}
\description{
Calculates the "effective weight" of each indicator and aggregate at the index level. The effective weight is calculated
as the final weight of each component in the index, and this is due to not just to its own weight, but also to the weights of
each aggregation that it is involved in, plus the number of indicators/aggregates in each group. The effective weight
is one way of understanding the final contribution of each indicator to the index. See also \code{vignette("weights")}.
}
\details{
This function replaces the now-defunct \code{effectiveWeight()} from COINr < v1.0.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "new_coin", quietly = TRUE)

# get effective weights as data frame
w_eff <- get_eff_weights(coin, out2 = "df")

head(w_eff)

}
