% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zicmp.R
\name{ZICMP Distribution}
\alias{ZICMP Distribution}
\alias{dzicmp}
\alias{rzicmp}
\alias{pzicmp}
\alias{qzicmp}
\alias{ezicmp}
\alias{vzicmp}
\title{ZICMP Distribution}
\usage{
dzicmp(x, lambda, nu, p, log = FALSE, control = NULL)

rzicmp(n, lambda, nu, p, control = NULL)

pzicmp(x, lambda, nu, p, control = NULL)

qzicmp(q, lambda, nu, p, log.p = FALSE, control = NULL)

ezicmp(lambda, nu, p, control = NULL)

vzicmp(lambda, nu, p, control = NULL)
}
\arguments{
\item{x}{vector of quantiles.}

\item{lambda}{rate parameter.}

\item{nu}{dispersion parameter.}

\item{p}{zero-inflation probability parameter.}

\item{log}{logical; if TRUE, probabilities are returned on log-scale.}

\item{control}{a \code{COMPoissonReg.control} object from \code{get.control}
or \code{NULL} to use global default.}

\item{n}{number of observations.}

\item{q}{vector of probabilities.}

\item{log.p}{logical; if TRUE, probabilities p are given as \eqn{\log(p)}.}
}
\value{
\describe{
\item{dzicmp}{density,}
\item{pzicmp}{cumulative probability,}
\item{qzicmp}{quantiles,}
\item{rzicmp}{generate random variates,}
\item{ezicmp}{expected value. and}
\item{vzicmp}{variance.}
}
}
\description{
Computes the density, cumulative probability, quantiles, and
random draws for the zero-inflated COM-Poisson distribution.
}
\references{
Kimberly F. Sellers and Andrew M. Raim (2016). A Flexible Zero-Inflated Model
to Address Data Dispersion. Computational Statistics and Data Analysis, 99,
68-80.
}
\author{
Kimberly Sellers, Andrew Raim
}
