% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSeQTL.R
\name{CSeQTL_smart}
\alias{CSeQTL_smart}
\title{CSeQTL_smart}
\usage{
CSeQTL_smart(
  TREC,
  hap2,
  ASREC,
  PHASE,
  SNP,
  RHO,
  XX,
  upPHI,
  upKAPPA,
  upETA,
  upPSI,
  upALPHA,
  iFullModel = FALSE,
  trim = FALSE,
  thres_TRIM = 10,
  hypotest = TRUE,
  swap = TRUE,
  numAS = 5,
  numASn = 5,
  numAS_het = 5,
  cistrans_thres = 0.01,
  gr_eps = 0.01,
  conv_eps = 0.001,
  ncores = 1,
  show = FALSE
)
}
\arguments{
\item{TREC}{An integer vector of total read counts.}

\item{hap2}{An integer vector of second haplotype counts}

\item{ASREC}{An integer vector of total haplotype counts}

\item{PHASE}{An integer vector of 0s and 1s denoting if a subject 
has available haplotype counts.}

\item{SNP}{An integer vector of phased genotypes coded 0 (AA),
1 (AB), 2 (BA), 3 (BB), and 5 (NA).}

\item{RHO}{A numeric matrix of cell type proportions. Rows 
correspond to subjects and columns correspond to cell types.}

\item{XX}{A numeric design matrix of baseline covariates 
including the intercept in the first column and centered 
continuous covariates.}

\item{upPHI}{A value of 0 or 1 indicating if a Poisson or
Negative binomial distribution is fitted, respectively.}

\item{upKAPPA}{An integer vector of zeroes and ones where 
\code{length(upKAPPA) == ncol(RHO)}. A requirement is \code{upKAPPA[1] = 1}.
Cell types with indices equal to one have the baseline fold change
between the q-th and reference cell type are estimated. Otherwise
that cell type's parameter is constrained to zero.}

\item{upETA}{An integer vector of zeroes and ones where
\code{length(upETA) == ncol(RHO)} indicating which
cell types eQTL parameters are estimated or constrained to their null.}

\item{upPSI}{A value of 0 or 1 indicating if a Binomial or
Beta-binomial distribution is fitted, respectively.}

\item{upALPHA}{An integer vector of zeroes and ones where
\code{length(upALPHA) == ncol(RHO)} indicating which
cell types' cis-trans parameters are estimated or 
constrained to their null.}

\item{iFullModel}{A boolean that if set to \code{TRUE} will 
determine the submodel of the full model, based by upKAPPA, 
upETA, and upALPHA parameters, that can be estimated with stability.}

\item{trim}{Boolean value. If \code{TRUE}, the TReC model will be fitted
without SNP genotype to calculate each subject's Cooks' distance.}

\item{thres_TRIM}{A positive numeric value to perform subject outcome trimming.
Subjects with standardized Cooks' Distances greater than the threshold are trimmed.}

\item{hypotest}{A boolean to perform eQTL significance 
testing and cis-trans eQTL testing.}

\item{swap}{A boolean to determine if the reference cell type should
be swapped with the cell type with highest TReC across alleles.}

\item{numAS}{A positive integer to determine if a subject has
enough total haplotype counts.}

\item{numASn}{A positive integer to determine how many subjects
have at least \code{numAS} to use the haplotype counts.}

\item{numAS_het}{A positive integer to determine how many subjects
with at least \code{numAS} are heterozygous (AB or BA). If
\code{sum(PHASE == 1 & ASREC >= numAS & (SNP == 1 | SNP == 2)) >= numAS_het},
those subjects haplotype counts will be used for TReCASE and cis/trans 
testing and estimation.}

\item{cistrans_thres}{A numeric value to determine the 
cis/trans test p-value cutoff.}

\item{gr_eps}{A numeric value to determine if convergence
is achieved based on the L2 norm of the gradient.}

\item{conv_eps}{A numeric value to determine if convergence
is achieved based on the L2 norm of the product of the 
inverse hessian and gradient.}

\item{ncores}{A positive integer specifying the number of threads available
to decrease computational runtime.}

\item{show}{A boolean value to display verbose output and plot intermediate 
simulated results.}
}
\value{
A R list of statistics and metrics after optimizing the model for a single SNP.
The list contains parameter MLEs, gradient vectors, covariance matrices,
gene expression estimates, fold change estimates, convergence indicators, 
likelihood ratio test statistics, and associated p-values.
}
\description{
A function to understand the novelties within CSeQTL. 
The user can experiment with trimming TReC, assess parameter estimation, 
perform hypothesis testing, actively constrain cell type-specific parameters,
when analyzing a single gene/SNP pair.
}
