% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma_Formula.R
\name{Gamma_Formula}
\alias{Gamma_Formula}
\title{Gamma CDF Equation Formula}
\usage{
Gamma_Formula(concentration, shape_location, scale)
}
\arguments{
\item{concentration}{The vector of concentration values for a selected pesticide,
that has a Gamma shaped species sensitivity distribution,
to run the equation on.}

\item{shape_location}{The k/shape value for the Gamma equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}

\item{scale}{The scale/theta value for the Gamma equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}
}
\value{
a numeric vector
}
\description{
Gamma CDF Equation Formula
}
\examples{
gamma_pesticide_concentrations <- c(0.000000001, 0.5, 2.7, 11)
Gamma_Formula(concentration = gamma_pesticide_concentrations,
shape_location = 0.23, scale = 1.3)
}
