% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generate_SMSNCens.R
\name{gen_SMSNCens_sample}
\alias{gen_SMSNCens_sample}
\title{Generate simulated censored data under heavy‑tailed Distributions}
\usage{
gen_SMSNCens_sample(
  n,
  x,
  beta,
  sigma2,
  lambda,
  nu,
  cens = "Int",
  pcens = 0,
  pna = 0,
  family = "ST"
)
}
\arguments{
\item{n}{Integer. Sample size to be generated.}

\item{x}{Numeric matrix of covariates (dimension \code{n x p}). Not contain missing values.}

\item{beta}{Numeric vector of regression coefficients of length \code{p}.}

\item{sigma2}{Positive numeric scalar. Scale parameter of SMSN class.}

\item{lambda}{Numeric scalar. Shape parameter that controls the skewness in the SMSN class. Ignored when \code{family = "N"}, \code{"T"} or \code{"CN"}.}

\item{nu}{Distribution-specific parameter: for \code{"ST"} or \code{"T"}, \code{nu} is a scalar > 2 (degrees of freedom); for \code{"SCN"} or \code{"CN"}, a vector \code{(nu1, nu2)} with values in (0,1). Ignored for \code{"SN"} and \code{"N"}.}

\item{cens}{Character string indicating the type of censoring: \code{"Left"}, \code{"Right"} or \code{"Int"}. Default is \code{"Int"}.}

\item{pcens}{Proportion of censored observations. Must be between 0 and 1. Default is \code{0}.}

\item{pna}{Proportion of missing values (treated as extreme interval censoring). Must be between 0 and 1. Only allowed when \code{cens = "Int"}. Default is \code{0}.}

\item{family}{Character string indicating the error distribution family. Possible values: \code{"SN"} (Skew-Normal), \code{"ST"} (Skew-t), \code{"SCN"} (Skew Contaminated Normal), \code{"N"} (Normal), \code{"T"} (Student-t) and \code{"CN"} (Contaminated Normal). Default is \code{"ST"}.}
}
\value{
A list with the following components:
\item{y}{Fully observed response values (uncensored).}
\item{yc}{Incomplete response values.}
\item{cc}{Censoring indicator. \code{0} for observed data and \code{1} for censored or missing case.}
\item{UL}{Vector of upper limits of the censoring interval. Equal to \code{NULL} for left or right censoring. For missing data, equal to \code{Inf}.}
}
\description{
Simulates a univariate linear regression dataset with censoring  and/or missing values in the response variable, considering that the error follows a SMSN distribution.
}
\details{
The following procedures are applied to the generated response variable with incomplete observation:
\itemize{
\item \strong{Left censoring}: values below a cutoff point (defined based on the \code{pcens}) are replaced by that cutoff, indicating that the true value is less than or equal to it.
\item \strong{Right censoring}: values above a cutoff point (also based on the \code{pcens}) are replaced by that value, indicating that the true value is greater than or equal to it.
\item \strong{Interval censoring}: a subset of observations is randomly selected (based on the \code{pcens}), and each value is replaced by an interval centered at the true value.
\item \strong{Missing data}: an additional subset of observations (defined based on the \code{pna}) is replaced by unbounded intervals of the form \code{(-Inf, Inf)}, representing complete uncertainty about the true value.
}
}
\examples{
set.seed(1997)

# Generate covariates and true parameter values
n      <- 500
x      <- cbind(1, rnorm(n))
beta   <- c(2, -1)
sigma2 <- 1
lambda <- 3
nu     <- 3

# Generate a simulated dataset under SMSN-ICR model, with interval censoring and/or missing values
sample <- gen_SMSNCens_sample(n = n, x = x, beta = beta, sigma2 = sigma2,
                         lambda = lambda, nu = nu, cens = "Int",
                         pcens = 0.1, pna = 0.05, family = "ST")

# Fit the SMSN-ICR model using the generated data
fit <- CensRegSMSN(sample$cc, x, sample$yc, cens = "Int", UL = sample$UL, get.init = TRUE,
                   show.envelope = TRUE, family = "ST")
}
