#' @importFrom magrittr %>%
#' @importFrom rlang .data
.read_progressFile <- function(fileToRead) {
  progress <- tibble::tibble()
  if (file.exists(fileToRead) && file.info(fileToRead)$size != 0) {
    progressLines <- utils::read.delim(fileToRead,
      row.names = NULL,
      sep = "",
      header = FALSE,
      colClasses = "character"
    )
    if (nrow(progressLines) > 2) {
      # removing nSubj nObs
      progressLines <- progressLines[-c(1:2), ]
      progressLines$V2 <- NULL
      colnames(progressLines)[colnames(progressLines) == "V1"] <- "Parameter"
      colnames(progressLines)[colnames(progressLines) == "V3"] <- "Value"
      progressLines <-
        progressLines %>%
        dplyr::filter(Parameter != ")") %>%
        dplyr::mutate(
          Parameter = gsub("\\(", "", Parameter),
          Value = as.double(gsub("\\)", "", Value))
        )

      progress <-
        utils::unstack(progressLines, form = "Value~Parameter") %>%
        dplyr::mutate(LL = -2 * .data$LL) %>%
        tibble::as_tibble()

      colnames(progress)[colnames(progress) == "LL"] <- "-2LL"
      colnames(progress)[colnames(progress) == "Iteration"] <- "-ITERATION"
    }
  }

  progress
}
