% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xplot_box.R
\name{xplot_box}
\alias{xplot_box}
\title{Default xpose box plot function}
\usage{
xplot_box(
  xpdb,
  mapping = NULL,
  type = "b",
  guide = FALSE,
  yscale = "continuous",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  tag = NULL,
  plot_name = "box_plot",
  gg_theme,
  xp_theme,
  opt,
  quiet,
  ...
)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{mapping}{List of aesthetics mappings to be used for the xpose plot
(e.g. \code{point_color}).}

\item{type}{String setting the type of plot to be used. Only 'b' applicable.}

\item{guide}{Enable guide display (e.g. unity line).}

\item{yscale}{Scale type for y axis (e.g. 'continuous', 'discrete', 'log10').}

\item{title}{Plot title. Use \code{NULL} to remove.}

\item{subtitle}{Plot subtitle. Use \code{NULL} to remove.}

\item{caption}{Page caption. Use \code{NULL} to remove.}

\item{tag}{Plot identification tag. Use \code{NULL} to remove.}

\item{plot_name}{Name to be used by \code{xpose::xpose_save()} when saving the plot.}

\item{gg_theme}{A complete ggplot2 theme object (e.g.
\code{ggplot2::theme_classic}), a function returning a complete
ggplot2 theme, or a change to the current \code{gg_theme}.}

\item{xp_theme}{A complete xpose theme object (e.g.
\code{\link[xpose]{theme_xp_default}}) or a list of modifications to the current
\code{xp_theme} (e.g. \code{list(point_color = 'red', line_linetype =
'dashed')}).}

\item{opt}{A list of options in order to create appropriate data input for
ggplot2. For more information see \code{\link[xpose]{data_opt}}.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}

\item{...}{Any additional aesthetics to be passed on \code{\link[xpose]{xplot_scatter}}.}
}
\value{
An object of class \code{xpose_plot}, \code{ggplot}, and \code{gg}. This object represents a customized plot created using \code{ggplot2}.
The \code{xpose_plot} class provides additional metadata and integration with \code{xpose} workflows, allowing for advanced
customization and compatibility with other \code{xpose} functions. Users can interact with the plot object as they
would with any \code{ggplot2} object, including modifying aesthetics, adding layers, or saving the plot.
}
\description{
Manually generate categorical covariate box plots against eta.
}
\section{Faceting}{

Every xpose plot function has built-in faceting functionalities. Faceting arguments
are passed to the functions \code{\link[ggforce]{facet_wrap_paginate}} when the \code{facets}
argument is a character string (e.g. \code{facets = c('SEX', 'MED1')}) or
\code{\link[ggforce]{facet_grid_paginate}} when facets is a formula (e.g. \code{facets = SEX~MED1}).
All xpose plot functions accept all the arguments for the \code{\link[ggforce]{facet_wrap_paginate}}
and \code{\link[ggforce]{facet_grid_paginate}} functions e.g. \code{dv_vs_ipred(xpdb_ex_pk,
facets = SEX~MED1, ncol = 3, nrow = 3, page = 1, margins = TRUE, labeller = 'label_both')}.

Faceting options can either be defined in plot functions (e.g. \code{dv_vs_ipred(xpdb_ex_pk,
facets = 'SEX')}) or assigned globally to an xpdb object via the \code{xp_theme} (e.g. \code{xpdb
<- update_themes(xpdb_ex_pk, xp_theme = list(facets = 'SEX'))}). In the latter example all plots
generate from this xpdb will automatically be stratified by `SEX`.

By default, some plot functions use a custom stratifying variable named `variable`, e.g.
\code{eta_distrib()}. When using the \code{facets} argument, `variable` needs to be added manually
e.g. \code{facets = c('SEX', 'variable')} or \code{facets = c('SEX', 'variable')}, but is optional,
when using the \code{facets} argument in \code{xp_theme} variable is automatically added whenever needed.
}

\section{Layers mapping}{

Plots can be customized by mapping arguments to specific layers. The naming convention is
layer_option where layer is one of the names defined in the list below and option is
any option supported by this layer e.g. boxplot_fill = 'blue', etc.
\itemize{
  \item box plot: options to \code{geom_boxplot}
  \item yscale: options to \code{scale_y_continuous} or \code{scale_y_log10}
}
}

\examples{
# Categorical Covariate MED1 vs ETA1
xplot_box(xpose::xpdb_ex_pk, ggplot2::aes(x = MED1, y = ETA1))

# Categorical Covariate SEX vs CL
xplot_box(xpose::xpdb_ex_pk, ggplot2::aes(x = SEX, y = CL))

}
\seealso{
\code{\link[xpose]{xplot_scatter}} \code{\link[xpose]{xplot_qq}}
}
