% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassificationEnsembles.R
\name{Classification}
\alias{Classification}
\title{classification—function to perform classification analysis and return results to the user.}
\usage{
Classification(
  data,
  colnum,
  numresamples,
  predict_on_new_data = c("Y", "N"),
  set_seed = c("Y", "N"),
  remove_VIF_above,
  scale_all_numeric_predictors_in_data,
  how_to_handle_strings = c(0("No strings"), 1("Strings as factors")),
  save_all_trained_models = c("Y", "N"),
  save_all_plots,
  use_parallel = c("Y", "N"),
  train_amount,
  test_amount,
  validation_amount
)
}
\arguments{
\item{data}{a data set that includes classification data. For example, the Carseats data in the ISLR package}

\item{colnum}{the number of the column. For example, in the Carseats data this is column 7, ShelveLoc with three values, Good, Medium and Bad}

\item{numresamples}{the number of times to resample the analysis}

\item{predict_on_new_data}{asks if the user has new data to be analyzed using the trained models that were just developed}

\item{set_seed}{Gives the user the option to set a seed}

\item{remove_VIF_above}{Removes columns with Variance Inflation Factors above the level chosen by the user}

\item{scale_all_numeric_predictors_in_data}{Scales all numeric predictors in the original data}

\item{how_to_handle_strings}{Converts strings to factor levels}

\item{save_all_trained_models}{Gives the user the option to save all trained models in the Environment}

\item{save_all_plots}{Saves all plots in the user's chosen format}

\item{use_parallel}{"Y" or "N" for parallel processing}

\item{train_amount}{set the amount for the training data}

\item{test_amount}{set the amount for the testing data}

\item{validation_amount}{Set the amount for the validation data}
}
\value{
a full analysis, including data visualizations, statistical summaries, and a full report on the results of 35 models on the data
}
\description{
classification—function to perform classification analysis and return results to the user.
}
