% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{filter_debris_flow}
\alias{filter_debris_flow}
\title{Flag debris in flow cytometry data.}
\usage{
filter_debris_flow(df, sum_max = 50000, cols = c("FSC-A", "SSC-A"))
}
\arguments{
\item{df}{A data frame containing scattering channels and
protein expression data.}

\item{sum_max}{Numeric; events whose sum of FSC-A and SSC-A is smaller than
this value are flagged.}

\item{cols}{Names of columns to use. This function is intended for use
with the area channel of forward and side scatter.}
}
\value{
A binary array with the same length as the number of rows in df.
TRUE for debris, FALSE for everything else.
}
\description{
Detect events in the lower left corner of FSC-A/SSC-A plots.
This function aims for high specificity, but not high sensitivity: for
Cleanet's purposes, it suffices to deplete debris, even if not all of
it is eliminated.
}
