% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv14_dispersion_test.R
\name{cv14_dispersion_test}
\alias{cv14_dispersion_test}
\title{Dispersion Test for Poisson Regression Models}
\usage{
cv14_dispersion_test(data, residue_col, cleaning_event_col)
}
\arguments{
\item{data}{A dataframe containing the observed data.}

\item{residue_col}{A string specifying the response column in the model.}

\item{cleaning_event_col}{A string specifying the explanatory variable in the model.}
}
\value{
A dataframe object with the results of the overdispersion test, including
}
\description{
Performs a dispersion test on a Poisson regression model to check for overdispersion.
The function fits a Poisson regression model to the data using the specified columns,
and then performs a dispersion test using the model.
}
\examples{
cv14_dispersion_test(data = Eq_Mic, residue_col = "Mic", cleaning_event_col = "CleaningEvent")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
the Z-value, P-value, and dispersion estimate.
}
