% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colordiff.R
\name{cie94}
\alias{cie94}
\title{Get the CIE94 color difference between two CIELab values.}
\usage{
cie94(
  lab_color1,
  lab_color2,
  k_L = 1,
  k_C = 1,
  k_H = 1,
  K1 = 0.045,
  K2 = 0.015,
  symmetric = FALSE
)
}
\arguments{
\item{lab_color1}{A vector with three components corresponding to a Lab value.}

\item{lab_color2}{A vector with three components corresponding to another Lab value.}

\item{k_L}{Weighting factor for the L component.}

\item{k_C}{Weighting factor for the C component.}

\item{k_H}{Weighting factor for the H component.}

\item{K1}{Application dependent weighting factor.}

\item{K2}{Application dependent weighting factor.}

\item{symmetric}{If TRUE, use the symmetric version of the formula.}
}
\value{
The CIE94 color difference between the two given values.
}
\description{
Get the CIE94 color difference between two CIELab values.
}
\references{
Sharma, G., & Bala, R. (Eds.). (2017). Digital color imaging handbook. CRC press.
}
