% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDdl.R
\name{createDdl}
\alias{createDdl}
\alias{createPrimaryKeys}
\alias{createForeignKeys}
\title{Create the OHDSI-SQL Common Data Model DDL code}
\usage{
createDdl(cdmVersion)

createPrimaryKeys(cdmVersion)

createForeignKeys(cdmVersion)
}
\arguments{
\item{cdmVersion}{The version of the CDM you are creating, e.g. 5.3, 5.4}
}
\value{
A character string containing the OHDSQL DDL

A string containing the OHDSQL for creation of primary keys in the OMOP CDM.

A string containing the OHDSQL for creation of foreign keys in the OMOP CDM.
}
\description{
The createDdl, createForeignKeys, and createPrimaryKeys functions each return a character string
containing their respective DDL SQL code in OHDSQL dialect for a specific CDM version.
The SQL they generate needs to be rendered and translated before it can be executed.
}
\details{
The DDL SQL code is created from a two csv files that detail the OMOP CDM Specifications.
These files also form the basis of the CDM documentation and the Data Quality
Dashboard.
}
\section{Functions}{
\itemize{
\item \code{createPrimaryKeys()}: createPrimaryKeys Returns a string containing the OHDSQL for creation of primary keys in the OMOP CDM.

\item \code{createForeignKeys()}: createForeignKeys Returns a string containing the OHDSQL for creation of foreign keys in the OMOP CDM.

}}
\examples{
\dontrun{
ddl <- createDdl("5.4")
pk <- createPrimaryKeys("5.4")
fk <- createForeignKeys("5.4")
}
}
