% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_humidity_adjustments.R
\name{add_humidity_adjustments}
\alias{add_humidity_adjustments}
\title{Adjust Humidity and add RH zones}
\usage{
add_humidity_adjustments(
  mydata,
  Temp = "Temp",
  RH = "RH",
  LowT = 16,
  HighT = 25,
  LowRH = 40,
  HighRH = 60,
  P_atm = 1013.25,
  ...
)
}
\arguments{
\item{mydata}{A dataframe containing temperature and relative humidity data.}

\item{Temp}{Character string name of the temperature column (default "Temp").}

\item{RH}{Character string name of the relative humidity column (default "RH").}

\item{LowT}{Numeric lower temperature threshold (default 16).}

\item{HighT}{Numeric higher temperature threshold (default 25).}

\item{LowRH}{Numeric lower relative humidity threshold (default 40).}

\item{HighRH}{Numeric higher relative humidity threshold (default 60).}

\item{P_atm}{Atmospheric pressure in kPa or hPa (currently unused, default 1013.25).}

\item{...}{Additional arguments passed to internal calculation functions.}
}
\value{
The input dataframe augmented with multiple humidity and temperature adjustment columns.

\describe{
  \item{AH}{Absolute Humidity (g/m³): The mass of water vapor per unit volume of air.}
  \item{DP}{Dew Point (°C): The temperature at which air becomes saturated and water vapor condenses.}
  \item{zone}{
     Categorical variable defining climate control actions based on temperature and RH:
     'Heating only', 'Dehum or heating', 'Cooling and hum', etc.}
  \item{TRH_zone}{Temperature-relative humidity category:
     'Hot', 'Cold', 'Dry', 'Hot and humid', etc.}
  \item{T_zone}{
     Temperature zone classification: 'Cold', 'Within', or 'Hot'.}
  \item{RH_zone}{Relative humidity zone classification: 'Dry', 'Within', or 'Humid'.}
  \item{dTemp}{
     Temperature difference from specified thresholds (°C),
     indicating required heating or cooling.}
  \item{dRH}{
     Relative humidity difference from specified thresholds (\%),
     indicating humidification or dehumidification.}
  \item{newTemp_TRHadj}{
     Adjusted temperature (°C) after applying temperature and relative humidity
     correction based on zone.}
  \item{newAH_TRHadj}{
     Adjusted absolute humidity (g/m³).}
  \item{newRH_TRHadj}{
     Adjusted relative humidity (\%) reflecting new temperature and absolute humidity.}
  \item{dTemp_TRHadj, dAH_TRHadj, dRH_TRHadj}{
     Differences between adjusted and original temperature, absolute humidity,
     and relative humidity respectively.}
  \item{newTemp_AHadj, newAH_AHadj, newRH_AHadj}{
     Adjustments based on absolute humidity only (i.e. dehumidification or humidification).}
  \item{newTemp_Tadj, newRH_Tadj, newAH_Tadj}{
     Adjustments based on temperature only (i.e. heating or cooling).}
}
}
\description{
This function processes a dataframe with temperature and relative humidity data
and classifies the data into climate control zones.
It generates adjusted temperature and humidity values based on thresholds.
}
\examples{

# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> add_humidity_adjustments() |> dplyr::glimpse()

}
