% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation_mechanism.R
\name{generate_method_prtrb}
\alias{generate_method_prtrb}
\title{Multiple method generation}
\usage{
generate_method_prtrb(
  X,
  cluster.method = "pam",
  range.k = c(2, 5),
  sample.k.method = "random",
  rep = 10,
  distance.method = "euclidian",
  func
)
}
\arguments{
\item{X}{input data Nsample x Nfeatures}

\item{cluster.method}{base clustering method: \code{c("kmeans", "pam", "custom")}}

\item{range.k}{vector of minimum and maximum values for k \code{c(min, max)}}

\item{sample.k.method}{method for the choice of k at each repeat \code{c("random", "silhouette")}}

\item{rep}{number of repeats}

\item{distance.method}{method for distance calculation:
\code{"euclidian"}, \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"}, \code{"minkowski"}.}

\item{func}{user-definrd function required if \code{cluster.method = "custom"}.
The function needs two inputs of X and k.}
}
\value{
matrix of clusterings Nsample x Nrepeat
}
\description{
Multiple method generation
}
\details{
At each repeat, k is selected randomly or based on the best silhouette width from a discrete uniform distribution between range.k[1] and range.k[2].
Then clustering is applied and result is returned.
}
\examples{
X = gaussian_clusters()$X
Clusters = generate_method_prtrb(X)

}
