% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_histogram}
\alias{get_histogram}
\title{Generate histogram of Reflectance for prediction with random forests}
\usage{
get_histogram(las, breaks = seq(-20, 0, by = 0.2))
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing an individually
segmented tree containing a `Reflectance` column representing relative
reflectance from from RIEGL vz400i Terrestrial Lidar Scanner. See `add_reflectance()`}

\item{breaks}{sequence of breaks for histograms, default from Cannon et al. 2025.}
}
\value{
data.frame with columns intensity and density
}
\description{
Generates a histogram of Reflectance intensities for prediction with
Random Forests. Histogram breaks can be defined.
}
\examples{
library(lidR)
library(CrownScorchTLS)
 #download external data from github repo
url <- paste0(
  "https://raw.githubusercontent.com/jbcannon/CrownScorchTLS-data/main/data/manual-clip-trees/",
  "M-04-15549_post.laz")
 las_file = tempfile(fileext = paste0(".", tools::file_ext(url)))
 download.file(url, las_file, mode = "wb", quiet = TRUE)
 las <- readLAS(las_file)

 # or load your own data
 #las <- readLAS('C:/path/to/your/file.laz')

las = add_reflectance(las)
histogram = get_histogram(las)
plot(density ~ intensity, data=histogram, xlab='Reflectance (dB)', type='l')
}
