% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarymodid.R
\name{summary.modid}
\alias{summary.modid}
\title{Summary Method for S3 Objects of Class \code{modid}}
\usage{
\method{summary}{modid}(object, ..., digits = 4)
}
\arguments{
\item{object}{A S3 object of class \code{modid}.}

\item{...}{Additional arguments.}

\item{digits}{The number of digits shown per estimate. The default is \code{digits = 4}.}
}
\value{
Model identification items (one less than the number of factors), factor loadings and absolute sum score for model identification items, squared factor loadings, and factor loadings for all items.
}
\description{
The summary method for the \code{\link[=modid]{modid()}} function.
}
\examples{
\dontrun{
# Load data
data("anes0809offwaves")
x <- anes0809offwaves
x <- x[,3:22] # Remove columns for age and gender

# Identify the DMIRT model
id <- modid(x)

# Call to summary
summary(id)

# Call to summary rounded off to 2 digits
summary(id, digits = 2)
}
}
\author{
Erik Forsberg
}
