% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{expand_value_to_points}
\alias{expand_value_to_points}
\title{expand_value_to_points}
\usage{
expand_value_to_points(value, scale, colors = c("red", "black", "green"))
}
\arguments{
\item{value}{A DEXi value: a single value (integer or float), a set (integer vector) or a \link{distribution}.}

\item{scale}{A \link{DexiScale} object.}

\item{colors}{\code{numeric(3)} representing colors to display "bad", "neutral" and "good" values, respectively.}
}
\value{
A \code{data.frame} consisting of:
\describe{
\item{\code{points}}{\code{numeric()}. \code{value} expanded to a vector of ordinal values.}
\item{\code{sizes}}{\code{numeric()}. Numeric values assigned to each corresponding ordinal values.
Normally \code{1.0} for set elements and in the \verb{(0,1]} interval for distribution membership values.}
\item{\code{colors}}{Colors assigned to corresponding value qualities.}
}
}
\description{
Expand a DEXi \code{value} to a sequence of individual elements (points).
Particularly aimed for graphic functions that display DEXi values
with dots of different sizes and colors.
}
\examples{
scl <- DexiDiscreteScale(values = c("L", "M", "H"))

expand_value_to_points(c(1, 3), scl)
# points sizes colors
# 1      1     1    red
# 2      3     1  green

expand_value_to_points(distribution(0.1, 0, 0.9), scl)
# points sizes colors
# 1      1   0.1    red
# 2      3   0.9  green

}
