% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{scale_value}
\alias{scale_value}
\title{scale_value}
\usage{
scale_value(value, scale)
}
\arguments{
\item{value}{A wide range of possible value types, including  integer, double, character and list vectors.}

\item{scale}{A \link{DexiScale} or derived object.}
}
\value{
The result is produced depending on \code{value} and \code{scale} according to the following tables.
For any scale type:
\preformatted{
value                          result
------------------------------+------------------
NULL                           NULL
length(value == 0)             NULL
NA                             scale$full_range()
other types                    ERROR
value contains any NULL or NA  ERROR
------------------------------+------------------
}

For continuous scales:
\preformatted{
value                          result
------------------------------+------------------
length(value != 1)             ERROR
character                      ERROR
named object                   ERROR
length(value == 1)             unclass(value)
------------------------------+------------------
}

For discrete scales:
\preformatted{
value                          result
------------------------------+------------------
distribution class             value
all-integer numeric vector     value
non all-integer numeric vector distribution(value)
"*" or "undef"...              scale$full_range()
list of value names            matched value set
list of name=p                 distribution(value)
------------------------------+------------------
}
}
\description{
Check and interpret \code{value} on \code{scale}.
}
\examples{
# Examples of successfully checked (witout error) values on a continuous scale
scl <- DexiContinuousScale()
scale_value(NULL, scl)               # NA
scale_value(c(), scl)                # NA
scale_value(list(), scl)             # NA
scale_value(character(), scl)        # NA
scale_value(NA, scl)                 # NA
scale_value(c(NA), scl)              # NA
scale_value(15.5, scl)               # 15.5
scale_value(distribution(15.5), scl) # 15.5

# Examples of successfully checked (without error) values on a discrete scale
scl <- DexiDiscreteScale(values = c("low", "med", "high"))
scale_value(NULL, scl)                        # NA
scale_value(c(), scl)                         # NA
scale_value(list(), scl)                      # NA
scale_value(NA, scl)                          # NA
scale_value("*", scl)                         # 1:3
scale_value("Undefined", scl)                 # 1:3
scale_value(2, scl)                           # 2
scale_value(c(-1, 2, 4), scl)                 # c(-1, 2, 4))
scale_value(distribution(c(-1, 2, 4)), scl)   # distribution(c(-1, 2, 4)))
scale_value(c(-1, 2.2, 4), scl)               # distribution(c(-1, 2.2, 4)))
scale_value("high", scl)                      # 3
scale_value(c("low", "high"), scl)            # c(1,3))
v <- c(0.5, 0.4)
names(v) <- c("low", "high")
scale_value(v, scl)                           # distribution(c(0.5, 0, 0.4)))
scale_value(list(high = 1.1, low = 2.2), scl) # distribution(c(2.2, 0, 1.1)))

}
