% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{add_ID_terms}
\alias{add_ID_terms}
\alias{add_interaction_terms}
\title{Add identity and interaction terms used in a Diversity-Interactions (DI) model to new data}
\usage{
add_ID_terms(data, model)

add_interaction_terms(data, model)
}
\arguments{
\item{data}{A data-frame with species proportions that sum to 1 to
create the identity effect groupings.}

\item{model}{A Diversity Interactions model object fit using the
\code{\link[DImodels:DI]{DI()}} or \code{\link[DImodels:autoDI]{autoDI()}}
functions from the \code{\link[DImodels:DImodels-package]{DImodels}}
or \code{\link[DImodelsMulti:DImulti]{DImulti()}} from the
\code{\link[DImodelsMulti:DImodelsMulti]{DImodelsMulti}} R packages.}
}
\value{
The original data-frame with additional columns appended at the end
describing the identity and interactions terms present in the model object.
}
\description{
Utility functions that accept a fitted Diversity-Interactions (DI) model
object along with a data frame and adds the necessary identity and interaction structures to
the data for making predictions using the model object specified in \code{`model`}.
}
\examples{
library(DImodels)
data(sim1)

# Fit DI models with different ID effect groupings
mod1 <- DI(y = "response", prop = 3:6,
           data = sim1, DImodel = "AV") # No ID grouping
mod2 <- DI(y = "response", prop = 3:6,
           data = sim1, DImodel = "AV",
           ID = c("ID1", "ID1", "ID2", "ID2"))
mod3 <- DI(y = "response", prop = 3:6,
           data = sim1, DImodel = "AV",
           ID = c("ID1", "ID1", "ID1", "ID1"))

# Create new data for adding interaction terms
newdata <- sim1[sim1$block == 1, 3:6]
print(head(newdata))

add_ID_terms(data = newdata, model = mod1)
add_ID_terms(data = newdata, model = mod2)
add_ID_terms(data = newdata, model = mod3)
library(DImodels)
data(sim1)

# Fit different DI models
mod1 <- DI(y = "response", prop = 3:6, data = sim1, DImodel = "AV")
mod2 <- DI(y = "response", prop = 3:6, data = sim1, DImodel = "FULL")
mod3 <- DI(y = "response", prop = 3:6, data = sim1, DImodel = "ADD")
mod4 <- DI(y = "response", prop = 3:6, data = sim1,
           FG = c("G", "G", "H", "H"), DImodel = "FG")

# Create new data for adding interaction terms
newdata <- sim1[sim1$block == 1, 3:6]
print(head(newdata))

add_interaction_terms(data = newdata, model = mod1)
add_interaction_terms(data = newdata, model = mod2)
add_interaction_terms(data = newdata, model = mod3)
add_interaction_terms(data = newdata, model = mod4)
}
