% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{coerceValue}
\alias{coerceValue}
\title{Coerce a character string to the same type as a target value}
\usage{
coerceValue(val, old)
}
\arguments{
\item{val}{A character string.}

\item{old}{An old value, whose type is the target type of \code{val}.}
}
\value{
A value of the same data type as \code{old} if possible.
}
\description{
Create a new value from a character string based on an old value, e.g., if
the old value is an integer, call \code{as.integer()} to coerce the string to
an integer.
}
\details{
This function only works with integer, double, date, time (\code{POSIXlt} or
\code{POSIXct}), and factor values. The date must be of the format
\verb{\\\%Y-\\\%m-\\\%dT\\\%H:\\\%M:\\\%SZ}. The factor value must be in the levels of
\code{old}, otherwise it will be coerced to \code{NA}.
}
\examples{
library(DT)
coerceValue('100', 1L)
coerceValue('1.23', 3.1416)
coerceValue('2018-02-14', Sys.Date())
coerceValue('2018-02-14T22:18:52Z', Sys.time())
coerceValue('setosa', iris$Species)
coerceValue('setosa2', iris$Species)  # NA
coerceValue('FALSE', TRUE)  # not supported
}
