% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EleChemr.R
\name{Gen_CV}
\alias{Gen_CV}
\title{General Purpose CV simulation}
\usage{
Gen_CV(
  Co = 0.001,
  Cred = 0,
  kco = 0,
  Dx1 = 1e-05,
  Eo1 = 0,
  kc1 = 0,
  Vi = 0.3,
  Vf = -0.3,
  Vs = 0.001,
  ko1 = 0.01,
  alpha1 = 0.5,
  Dred = 1e-05,
  Dred2 = 1e-05,
  Eo2 = 0,
  kc2 = 0,
  ko2 = 0,
  alpha2 = 0.5,
  Dm = 0.45,
  Dred3 = 1e-05,
  Eo3 = 0,
  kc3 = 0,
  ko3 = 0,
  alpha3 = 0.5,
  Dred4 = 1e-05,
  Eo4 = 0,
  kc4 = 0,
  ko4 = 0,
  alpha4 = 0.5,
  Temp = 298.15,
  n = 1,
  Area = 1,
  l = 100,
  DerApprox = 2,
  errCheck = FALSE,
  Method = "Euler"
)
}
\arguments{
\item{Co}{bulk concentration oxidated speciesexpressed in Molar}

\item{Cred}{bulk concentration of reduced species expressed in Molar}

\item{kco}{Chemical rate constant for Ox Species expressed in s^-1}

\item{Dx1}{diffusion coefficient of the oxidized species expressed in cm^2/s}

\item{Eo1}{reduction potential of the first electrochemical reaction expressed in Volt}

\item{kc1}{Chemical rate constant for Red Species expressed in s^-1}

\item{Vi}{initial potential of the sweep expressed in Volt}

\item{Vf}{final potential of the sweep expressed in Volt}

\item{Vs}{potential scan rate of the simulation expressed in V/s}

\item{ko1}{heterogeneous electron transfer rate constant of the first electrochemical reaction expressed in m/s}

\item{alpha1}{charge transfer coefficient of the first electrochemical reaction}

\item{Dred}{diffusion coefficient of the first reduced species expressed in cm^2/S}

\item{Dred2}{diffusion coefficient of the second reduced species expressed in cm^2/s}

\item{Eo2}{reduction potential of the second electrochemical reaction expressed in Volt}

\item{kc2}{Chemical rate constant for second Red Species expressed in s^-1}

\item{ko2}{heterogeneous electron transfer rate constant of the second electrochemical reaction expressed in m/s}

\item{alpha2}{charge transfer coefficient of the second electrochemical reaction}

\item{Dm}{simulation parameter, maximum 0.5 for explicit methods}

\item{Dred3}{diffusion coefficient of the third reduced species expressed in cm^2/s}

\item{Eo3}{reduction potential of the third electrochemical reaction expressed in Volt}

\item{kc3}{Chemical rate constant for third Red Species expressed in s^-1}

\item{ko3}{heterogeneous electron transfer rate constant of the third electrochemical reaction expressed in m/s}

\item{alpha3}{charge transfer coefficient of the third electrochemical reaction}

\item{Dred4}{diffusion coefficient of the fourth reduced species cm^2/s}

\item{Eo4}{reduction potential of the fourth electrochemical reaction expressed in Volt}

\item{kc4}{Chemical rate constant for fourth Red Species expressed in s^-1}

\item{ko4}{heterogeneous electron transfer rate constant of the fourth electrochemical reaction expressed in m/s}

\item{alpha4}{charge transfer coefficient of the fourth electrochemical reaction}

\item{Temp}{temperature in kelvin}

\item{n}{number of electrons involved in the process}

\item{Area}{area of the electrode expressed in cm^2}

\item{l}{number of time steps of the simulation}

\item{DerApprox}{number of point for the approximation of the first derivative}

\item{errCheck}{if true the function returns a list with parameters for CottrCheck function}

\item{Method}{method to be used for the simulation = "Euler" "BI" "RK4" "CN "BDF"}
}
\value{
if errCheck == F a graph I vs E, if errCheck == T a list
}
\description{
Return a graph I vs E of the electrochemical process, up to 4 EE mechanisms and CE mechanisms can be simulated
}
\examples{
Gen_CV(Co = 0.001, DerApprox = 2, Dm = 0.45, errCheck = FALSE, Method = "Euler")
Gen_CV(Co = 0.001, Eo2 = -0.15, Dm = 0.45, kc1 = 0.0001)

}
